<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedirectRequestType StructType
 * @subpackage Structs
 */
class RedirectRequestType extends AbstractStructBase
{
    /**
     * The NotifyUrl
     * @var string
     */
    public $NotifyUrl;
    /**
     * The ReturnUrl
     * @var string
     */
    public $ReturnUrl;
    /**
     * The Target
     * Meta information extracted from the WSDL
     * - default: _self
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target;
    /**
     * Constructor method for RedirectRequestType
     * @uses RedirectRequestType::setNotifyUrl()
     * @uses RedirectRequestType::setReturnUrl()
     * @uses RedirectRequestType::setTarget()
     * @param string $notifyUrl
     * @param string $returnUrl
     * @param string $target
     */
    public function __construct($notifyUrl = null, $returnUrl = null, $target = '_self')
    {
        $this
            ->setNotifyUrl($notifyUrl)
            ->setReturnUrl($returnUrl)
            ->setTarget($target);
    }
    /**
     * Get NotifyUrl value
     * @return string|null
     */
    public function getNotifyUrl()
    {
        return $this->NotifyUrl;
    }
    /**
     * Set NotifyUrl value
     * @param string $notifyUrl
     * @return \StructType\RedirectRequestType
     */
    public function setNotifyUrl($notifyUrl = null)
    {
        // validation for constraint: string
        if (!is_null($notifyUrl) && !is_string($notifyUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notifyUrl, true), gettype($notifyUrl)), __LINE__);
        }
        $this->NotifyUrl = $notifyUrl;
        return $this;
    }
    /**
     * Get ReturnUrl value
     * @return string|null
     */
    public function getReturnUrl()
    {
        return $this->ReturnUrl;
    }
    /**
     * Set ReturnUrl value
     * @param string $returnUrl
     * @return \StructType\RedirectRequestType
     */
    public function setReturnUrl($returnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($returnUrl) && !is_string($returnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnUrl, true), gettype($returnUrl)), __LINE__);
        }
        $this->ReturnUrl = $returnUrl;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\RedirectRequestType
     */
    public function setTarget($target = '_self')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedirectRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
