<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstructionsResponseType StructType
 * @subpackage Structs
 */
class InstructionsResponseType extends AbstractStructBase
{
    /**
     * The Instruction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Instruction;
    /**
     * Constructor method for InstructionsResponseType
     * @uses InstructionsResponseType::setInstruction()
     * @param string $instruction
     */
    public function __construct($instruction = null)
    {
        $this
            ->setInstruction($instruction);
    }
    /**
     * Get Instruction value
     * @return string|null
     */
    public function getInstruction()
    {
        return $this->Instruction;
    }
    /**
     * Set Instruction value
     * @param string $instruction
     * @return \StructType\InstructionsResponseType
     */
    public function setInstruction($instruction = null)
    {
        // validation for constraint: string
        if (!is_null($instruction) && !is_string($instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instruction, true), gettype($instruction)), __LINE__);
        }
        $this->Instruction = $instruction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InstructionsResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
