<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankPaymentRequestType StructType
 * @subpackage Structs
 */
class BankPaymentRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountHolder
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountHolder;
    /**
     * The VaultId
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VaultId;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The BankAccountType
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountType;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BIC;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - choice: AccountHolder | BankAccountType | BankCode | BankName | BIC | IBAN | Country | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Vault
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The BudgetPeriod
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $BudgetPeriod;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The ThreeDSecure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureType
     */
    public $ThreeDSecure;
    /**
     * The Risk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskType
     */
    public $Risk;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * Constructor method for BankPaymentRequestType
     * @uses BankPaymentRequestType::setCustomer()
     * @uses BankPaymentRequestType::setAccountNumber()
     * @uses BankPaymentRequestType::setAccountHolder()
     * @uses BankPaymentRequestType::setVaultId()
     * @uses BankPaymentRequestType::setAccount()
     * @uses BankPaymentRequestType::setBankAccountType()
     * @uses BankPaymentRequestType::setBankCode()
     * @uses BankPaymentRequestType::setBankName()
     * @uses BankPaymentRequestType::setBIC()
     * @uses BankPaymentRequestType::setIBAN()
     * @uses BankPaymentRequestType::setCountry()
     * @uses BankPaymentRequestType::setVault()
     * @uses BankPaymentRequestType::setBudgetPeriod()
     * @uses BankPaymentRequestType::setRedirect()
     * @uses BankPaymentRequestType::setOrder()
     * @uses BankPaymentRequestType::setThreeDSecure()
     * @uses BankPaymentRequestType::setRisk()
     * @uses BankPaymentRequestType::setUserDefinedFields()
     * @uses BankPaymentRequestType::setBillingDescriptor()
     * @param \StructType\PersonType $customer
     * @param string $accountNumber
     * @param string $accountHolder
     * @param string $vaultId
     * @param \StructType\PayGateAccountType $account
     * @param string $bankAccountType
     * @param string $bankCode
     * @param string $bankName
     * @param string $bIC
     * @param string $iBAN
     * @param string $country
     * @param bool $vault
     * @param string $budgetPeriod
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @param \StructType\RiskType $risk
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @param string $billingDescriptor
     */
    public function __construct(\StructType\PersonType $customer = null, $accountNumber = null, $accountHolder = null, $vaultId = null, \StructType\PayGateAccountType $account = null, $bankAccountType = null, $bankCode = null, $bankName = null, $bIC = null, $iBAN = null, $country = null, $vault = false, $budgetPeriod = null, \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\ThreeDSecureType $threeDSecure = null, \StructType\RiskType $risk = null, array $userDefinedFields = array(), $billingDescriptor = null)
    {
        $this
            ->setCustomer($customer)
            ->setAccountNumber($accountNumber)
            ->setAccountHolder($accountHolder)
            ->setVaultId($vaultId)
            ->setAccount($account)
            ->setBankAccountType($bankAccountType)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBIC($bIC)
            ->setIBAN($iBAN)
            ->setCountry($country)
            ->setVault($vault)
            ->setBudgetPeriod($budgetPeriod)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setThreeDSecure($threeDSecure)
            ->setRisk($risk)
            ->setUserDefinedFields($userDefinedFields)
            ->setBillingDescriptor($billingDescriptor);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\BankPaymentRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BankPaymentRequestType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountHolder value
     * @return string
     */
    public function getAccountHolder()
    {
        return isset($this->AccountHolder) ? $this->AccountHolder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountHolder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountHolder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountHolderForChoiceConstraintsFromSetAccountHolder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankAccountType',
            'BankCode',
            'BankName',
            'BIC',
            'IBAN',
            'Country',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountHolder can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountHolder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountHolder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $accountHolder
     * @return \StructType\BankPaymentRequestType
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolder, true), gettype($accountHolder)), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($accountHolderChoiceErrorMessage = self::validateAccountHolderForChoiceConstraintsFromSetAccountHolder($accountHolder))) {
            throw new \InvalidArgumentException($accountHolderChoiceErrorMessage, __LINE__);
        }
        if (is_null($accountHolder) || (is_array($accountHolder) && empty($accountHolder))) {
            unset($this->AccountHolder);
        } else {
            $this->AccountHolder = $accountHolder;
        }
        return $this;
    }
    /**
     * Get VaultId value
     * @return string
     */
    public function getVaultId()
    {
        return isset($this->VaultId) ? $this->VaultId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVaultId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVaultId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVaultIdForChoiceConstraintsFromSetVaultId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankAccountType',
            'BankCode',
            'BankName',
            'BIC',
            'IBAN',
            'Country',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VaultId can\'t be set as the property %s is already set. Only one property must be set among these properties: VaultId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VaultId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $vaultId
     * @return \StructType\BankPaymentRequestType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vaultId, true), gettype($vaultId)), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($vaultIdChoiceErrorMessage = self::validateVaultIdForChoiceConstraintsFromSetVaultId($vaultId))) {
            throw new \InvalidArgumentException($vaultIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($vaultId) || (is_array($vaultId) && empty($vaultId))) {
            unset($this->VaultId);
        } else {
            $this->VaultId = $vaultId;
        }
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\BankPaymentRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string|null
     */
    public function getBankAccountType()
    {
        return isset($this->BankAccountType) ? $this->BankAccountType : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankAccountType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAccountType method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankAccountTypeForChoiceConstraintsFromSetBankAccountType($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankCode',
            'BankName',
            'BIC',
            'IBAN',
            'Country',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankAccountType can\'t be set as the property %s is already set. Only one property must be set among these properties: BankAccountType, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankAccountType value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\BankPaymentRequestType
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BankAccountType', is_array($bankAccountType) ? implode(', ', $bankAccountType) : var_export($bankAccountType, true), implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($bankAccountTypeChoiceErrorMessage = self::validateBankAccountTypeForChoiceConstraintsFromSetBankAccountType($bankAccountType))) {
            throw new \InvalidArgumentException($bankAccountTypeChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankAccountType) || (is_array($bankAccountType) && empty($bankAccountType))) {
            unset($this->BankAccountType);
        } else {
            $this->BankAccountType = $bankAccountType;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankCodeForChoiceConstraintsFromSetBankCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankAccountType',
            'BankName',
            'BIC',
            'IBAN',
            'Country',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankCode can\'t be set as the property %s is already set. Only one property must be set among these properties: BankCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $bankCode
     * @return \StructType\BankPaymentRequestType
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($bankCodeChoiceErrorMessage = self::validateBankCodeForChoiceConstraintsFromSetBankCode($bankCode))) {
            throw new \InvalidArgumentException($bankCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankNameForChoiceConstraintsFromSetBankName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankAccountType',
            'BankCode',
            'BIC',
            'IBAN',
            'Country',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankName can\'t be set as the property %s is already set. Only one property must be set among these properties: BankName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $bankName
     * @return \StructType\BankPaymentRequestType
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($bankNameChoiceErrorMessage = self::validateBankNameForChoiceConstraintsFromSetBankName($bankName))) {
            throw new \InvalidArgumentException($bankNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return isset($this->BIC) ? $this->BIC : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBIC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBIC method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBICForChoiceConstraintsFromSetBIC($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankAccountType',
            'BankCode',
            'BankName',
            'IBAN',
            'Country',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BIC can\'t be set as the property %s is already set. Only one property must be set among these properties: BIC, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BIC value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $bIC
     * @return \StructType\BankPaymentRequestType
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($bICChoiceErrorMessage = self::validateBICForChoiceConstraintsFromSetBIC($bIC))) {
            throw new \InvalidArgumentException($bICChoiceErrorMessage, __LINE__);
        }
        if (is_null($bIC) || (is_array($bIC) && empty($bIC))) {
            unset($this->BIC);
        } else {
            $this->BIC = $bIC;
        }
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIBAN method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIBAN method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIBANForChoiceConstraintsFromSetIBAN($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankAccountType',
            'BankCode',
            'BankName',
            'BIC',
            'Country',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IBAN can\'t be set as the property %s is already set. Only one property must be set among these properties: IBAN, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IBAN value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $iBAN
     * @return \StructType\BankPaymentRequestType
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($iBANChoiceErrorMessage = self::validateIBANForChoiceConstraintsFromSetIBAN($iBAN))) {
            throw new \InvalidArgumentException($iBANChoiceErrorMessage, __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCountryForChoiceConstraintsFromSetCountry($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountHolder',
            'BankAccountType',
            'BankCode',
            'BankName',
            'BIC',
            'IBAN',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Country can\'t be set as the property %s is already set. Only one property must be set among these properties: Country, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Country value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\BankPaymentRequestType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryType', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(AccountHolder, BankAccountType, BankCode, BankName, BIC, IBAN, Country, VaultId)
        if ('' !== ($countryChoiceErrorMessage = self::validateCountryForChoiceConstraintsFromSetCountry($country))) {
            throw new \InvalidArgumentException($countryChoiceErrorMessage, __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\BankPaymentRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vault, true), gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get BudgetPeriod value
     * @return string|null
     */
    public function getBudgetPeriod()
    {
        return $this->BudgetPeriod;
    }
    /**
     * Set BudgetPeriod value
     * @param string $budgetPeriod
     * @return \StructType\BankPaymentRequestType
     */
    public function setBudgetPeriod($budgetPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($budgetPeriod) && !is_string($budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budgetPeriod, true), gettype($budgetPeriod)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($budgetPeriod) && mb_strlen($budgetPeriod) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($budgetPeriod)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($budgetPeriod) && mb_strlen($budgetPeriod) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($budgetPeriod)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($budgetPeriod) && !preg_match('/[0-9]+/', $budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($budgetPeriod, true)), __LINE__);
        }
        $this->BudgetPeriod = $budgetPeriod;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\BankPaymentRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\BankPaymentRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ThreeDSecure value
     * @return \StructType\ThreeDSecureType|null
     */
    public function getThreeDSecure()
    {
        return $this->ThreeDSecure;
    }
    /**
     * Set ThreeDSecure value
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @return \StructType\BankPaymentRequestType
     */
    public function setThreeDSecure(\StructType\ThreeDSecureType $threeDSecure = null)
    {
        $this->ThreeDSecure = $threeDSecure;
        return $this;
    }
    /**
     * Get Risk value
     * @return \StructType\RiskType|null
     */
    public function getRisk()
    {
        return $this->Risk;
    }
    /**
     * Set Risk value
     * @param \StructType\RiskType $risk
     * @return \StructType\BankPaymentRequestType
     */
    public function setRisk(\StructType\RiskType $risk = null)
    {
        $this->Risk = $risk;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankPaymentRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$bankPaymentRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($bankPaymentRequestTypeUserDefinedFieldsItem) ? get_class($bankPaymentRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($bankPaymentRequestTypeUserDefinedFieldsItem), var_export($bankPaymentRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\BankPaymentRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\BankPaymentRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\BankPaymentRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankPaymentRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
