<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Single ServiceType
 * @subpackage Services
 */
class Single extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SinglePayout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SinglePayoutRequest $singlePayoutRequest
     * @return \StructType\SinglePayoutResponse|bool
     */
    public function SinglePayout(\StructType\SinglePayoutRequest $singlePayoutRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SinglePayout($singlePayoutRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SinglePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SinglePaymentRequest $singlePaymentRequest
     * @return \StructType\SinglePaymentResponse|bool
     */
    public function SinglePayment(\StructType\SinglePaymentRequest $singlePaymentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SinglePayment($singlePaymentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SingleFollowUp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SingleFollowUpRequest $singleFollowUpRequest
     * @return \StructType\SingleFollowUpResponse|bool
     */
    public function SingleFollowUp(\StructType\SingleFollowUpRequest $singleFollowUpRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SingleFollowUp($singleFollowUpRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SingleVault
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SingleVaultRequest $singleVaultRequest
     * @return \StructType\SingleVaultResponse|bool
     */
    public function SingleVault(\StructType\SingleVaultRequest $singleVaultRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SingleVault($singleVaultRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SingleFollowUpResponse|\StructType\SinglePaymentResponse|\StructType\SinglePayoutResponse|\StructType\SingleVaultResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
