<?php

namespace EnumType;

/**
 * This class stands for PaymentMethodType EnumType
 * @subpackage Enumerations
 */
class PaymentMethodType
{
    /**
     * Constant for value 'CC'
     * Meta information extracted from the WSDL
     * - documentation: Credit Card
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'DC'
     * Meta information extracted from the WSDL
     * - documentation: Debit Card
     * @return string 'DC'
     */
    const VALUE_DC = 'DC';
    /**
     * Constant for value 'EW'
     * Meta information extracted from the WSDL
     * - documentation: eWallet
     * @return string 'EW'
     */
    const VALUE_EW = 'EW';
    /**
     * Constant for value 'BT'
     * Meta information extracted from the WSDL
     * - documentation: Bank Transfer
     * @return string 'BT'
     */
    const VALUE_BT = 'BT';
    /**
     * Constant for value 'CV'
     * Meta information extracted from the WSDL
     * - documentation: Cash Voucher
     * @return string 'CV'
     */
    const VALUE_CV = 'CV';
    /**
     * Constant for value 'PC'
     * Meta information extracted from the WSDL
     * - documentation: Pre-Paid Card
     * @return string 'PC'
     */
    const VALUE_PC = 'PC';
    /**
     * Constant for value 'MO'
     * Meta information extracted from the WSDL
     * - documentation: Mobile Payment
     * @return string 'MO'
     */
    const VALUE_MO = 'MO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CC
     * @uses self::VALUE_DC
     * @uses self::VALUE_EW
     * @uses self::VALUE_BT
     * @uses self::VALUE_CV
     * @uses self::VALUE_PC
     * @uses self::VALUE_MO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CC,
            self::VALUE_DC,
            self::VALUE_EW,
            self::VALUE_BT,
            self::VALUE_CV,
            self::VALUE_PC,
            self::VALUE_MO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
