<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePaymentRequest StructType
 * @subpackage Structs
 */
class SinglePaymentRequest extends AbstractStructBase
{
    /**
     * The CardPaymentRequest
     * Meta information extracted from the WSDL
     * - choice: CardPaymentRequest | WebPaymentRequest | TokenPaymentRequest | BankPaymentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CardPaymentRequestType
     */
    public $CardPaymentRequest;
    /**
     * The WebPaymentRequest
     * Meta information extracted from the WSDL
     * - choice: CardPaymentRequest | WebPaymentRequest | TokenPaymentRequest | BankPaymentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WebPaymentRequestType
     */
    public $WebPaymentRequest;
    /**
     * The TokenPaymentRequest
     * Meta information extracted from the WSDL
     * - choice: CardPaymentRequest | WebPaymentRequest | TokenPaymentRequest | BankPaymentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TokenPaymentRequestType
     */
    public $TokenPaymentRequest;
    /**
     * The BankPaymentRequest
     * Meta information extracted from the WSDL
     * - choice: CardPaymentRequest | WebPaymentRequest | TokenPaymentRequest | BankPaymentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\BankPaymentRequestType
     */
    public $BankPaymentRequest;
    /**
     * Constructor method for SinglePaymentRequest
     * @uses SinglePaymentRequest::setCardPaymentRequest()
     * @uses SinglePaymentRequest::setWebPaymentRequest()
     * @uses SinglePaymentRequest::setTokenPaymentRequest()
     * @uses SinglePaymentRequest::setBankPaymentRequest()
     * @param \StructType\CardPaymentRequestType $cardPaymentRequest
     * @param \StructType\WebPaymentRequestType $webPaymentRequest
     * @param \StructType\TokenPaymentRequestType $tokenPaymentRequest
     * @param \StructType\BankPaymentRequestType $bankPaymentRequest
     */
    public function __construct(\StructType\CardPaymentRequestType $cardPaymentRequest = null, \StructType\WebPaymentRequestType $webPaymentRequest = null, \StructType\TokenPaymentRequestType $tokenPaymentRequest = null, \StructType\BankPaymentRequestType $bankPaymentRequest = null)
    {
        $this
            ->setCardPaymentRequest($cardPaymentRequest)
            ->setWebPaymentRequest($webPaymentRequest)
            ->setTokenPaymentRequest($tokenPaymentRequest)
            ->setBankPaymentRequest($bankPaymentRequest);
    }
    /**
     * Get CardPaymentRequest value
     * @return \StructType\CardPaymentRequestType|null
     */
    public function getCardPaymentRequest()
    {
        return isset($this->CardPaymentRequest) ? $this->CardPaymentRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardPaymentRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardPaymentRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardPaymentRequestForChoiceConstraintsFromSetCardPaymentRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WebPaymentRequest',
            'TokenPaymentRequest',
            'BankPaymentRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardPaymentRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: CardPaymentRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardPaymentRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardPaymentRequestType $cardPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setCardPaymentRequest(\StructType\CardPaymentRequestType $cardPaymentRequest = null)
    {
        // validation for constraint: choice(CardPaymentRequest, WebPaymentRequest, TokenPaymentRequest, BankPaymentRequest)
        if ('' !== ($cardPaymentRequestChoiceErrorMessage = self::validateCardPaymentRequestForChoiceConstraintsFromSetCardPaymentRequest($cardPaymentRequest))) {
            throw new \InvalidArgumentException($cardPaymentRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardPaymentRequest) || (is_array($cardPaymentRequest) && empty($cardPaymentRequest))) {
            unset($this->CardPaymentRequest);
        } else {
            $this->CardPaymentRequest = $cardPaymentRequest;
        }
        return $this;
    }
    /**
     * Get WebPaymentRequest value
     * @return \StructType\WebPaymentRequestType|null
     */
    public function getWebPaymentRequest()
    {
        return isset($this->WebPaymentRequest) ? $this->WebPaymentRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWebPaymentRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebPaymentRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWebPaymentRequestForChoiceConstraintsFromSetWebPaymentRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPaymentRequest',
            'TokenPaymentRequest',
            'BankPaymentRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WebPaymentRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: WebPaymentRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WebPaymentRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebPaymentRequestType $webPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setWebPaymentRequest(\StructType\WebPaymentRequestType $webPaymentRequest = null)
    {
        // validation for constraint: choice(CardPaymentRequest, WebPaymentRequest, TokenPaymentRequest, BankPaymentRequest)
        if ('' !== ($webPaymentRequestChoiceErrorMessage = self::validateWebPaymentRequestForChoiceConstraintsFromSetWebPaymentRequest($webPaymentRequest))) {
            throw new \InvalidArgumentException($webPaymentRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($webPaymentRequest) || (is_array($webPaymentRequest) && empty($webPaymentRequest))) {
            unset($this->WebPaymentRequest);
        } else {
            $this->WebPaymentRequest = $webPaymentRequest;
        }
        return $this;
    }
    /**
     * Get TokenPaymentRequest value
     * @return \StructType\TokenPaymentRequestType|null
     */
    public function getTokenPaymentRequest()
    {
        return isset($this->TokenPaymentRequest) ? $this->TokenPaymentRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTokenPaymentRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTokenPaymentRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTokenPaymentRequestForChoiceConstraintsFromSetTokenPaymentRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPaymentRequest',
            'WebPaymentRequest',
            'BankPaymentRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TokenPaymentRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: TokenPaymentRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TokenPaymentRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TokenPaymentRequestType $tokenPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setTokenPaymentRequest(\StructType\TokenPaymentRequestType $tokenPaymentRequest = null)
    {
        // validation for constraint: choice(CardPaymentRequest, WebPaymentRequest, TokenPaymentRequest, BankPaymentRequest)
        if ('' !== ($tokenPaymentRequestChoiceErrorMessage = self::validateTokenPaymentRequestForChoiceConstraintsFromSetTokenPaymentRequest($tokenPaymentRequest))) {
            throw new \InvalidArgumentException($tokenPaymentRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($tokenPaymentRequest) || (is_array($tokenPaymentRequest) && empty($tokenPaymentRequest))) {
            unset($this->TokenPaymentRequest);
        } else {
            $this->TokenPaymentRequest = $tokenPaymentRequest;
        }
        return $this;
    }
    /**
     * Get BankPaymentRequest value
     * @return \StructType\BankPaymentRequestType|null
     */
    public function getBankPaymentRequest()
    {
        return isset($this->BankPaymentRequest) ? $this->BankPaymentRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankPaymentRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankPaymentRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankPaymentRequestForChoiceConstraintsFromSetBankPaymentRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPaymentRequest',
            'WebPaymentRequest',
            'TokenPaymentRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankPaymentRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: BankPaymentRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankPaymentRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankPaymentRequestType $bankPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setBankPaymentRequest(\StructType\BankPaymentRequestType $bankPaymentRequest = null)
    {
        // validation for constraint: choice(CardPaymentRequest, WebPaymentRequest, TokenPaymentRequest, BankPaymentRequest)
        if ('' !== ($bankPaymentRequestChoiceErrorMessage = self::validateBankPaymentRequestForChoiceConstraintsFromSetBankPaymentRequest($bankPaymentRequest))) {
            throw new \InvalidArgumentException($bankPaymentRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankPaymentRequest) || (is_array($bankPaymentRequest) && empty($bankPaymentRequest))) {
            unset($this->BankPaymentRequest);
        } else {
            $this->BankPaymentRequest = $bankPaymentRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SinglePaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
