<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedirectResponseType StructType
 * @subpackage Structs
 */
class RedirectResponseType extends AbstractStructBase
{
    /**
     * The RedirectUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RedirectUrl;
    /**
     * The UrlParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UrlParams;
    /**
     * Constructor method for RedirectResponseType
     * @uses RedirectResponseType::setRedirectUrl()
     * @uses RedirectResponseType::setUrlParams()
     * @param string $redirectUrl
     * @param \StructType\KeyValueType[] $urlParams
     */
    public function __construct($redirectUrl = null, array $urlParams = array())
    {
        $this
            ->setRedirectUrl($redirectUrl)
            ->setUrlParams($urlParams);
    }
    /**
     * Get RedirectUrl value
     * @return string
     */
    public function getRedirectUrl()
    {
        return $this->RedirectUrl;
    }
    /**
     * Set RedirectUrl value
     * @param string $redirectUrl
     * @return \StructType\RedirectResponseType
     */
    public function setRedirectUrl($redirectUrl = null)
    {
        // validation for constraint: string
        if (!is_null($redirectUrl) && !is_string($redirectUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectUrl, true), gettype($redirectUrl)), __LINE__);
        }
        $this->RedirectUrl = $redirectUrl;
        return $this;
    }
    /**
     * Get UrlParams value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUrlParams()
    {
        return $this->UrlParams;
    }
    /**
     * This method is responsible for validating the values passed to the setUrlParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUrlParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUrlParamsForArrayConstraintsFromSetUrlParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $redirectResponseTypeUrlParamsItem) {
            // validation for constraint: itemType
            if (!$redirectResponseTypeUrlParamsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($redirectResponseTypeUrlParamsItem) ? get_class($redirectResponseTypeUrlParamsItem) : sprintf('%s(%s)', gettype($redirectResponseTypeUrlParamsItem), var_export($redirectResponseTypeUrlParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UrlParams property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UrlParams value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $urlParams
     * @return \StructType\RedirectResponseType
     */
    public function setUrlParams(array $urlParams = array())
    {
        // validation for constraint: array
        if ('' !== ($urlParamsArrayErrorMessage = self::validateUrlParamsForArrayConstraintsFromSetUrlParams($urlParams))) {
            throw new \InvalidArgumentException($urlParamsArrayErrorMessage, __LINE__);
        }
        $this->UrlParams = $urlParams;
        return $this;
    }
    /**
     * Add item to UrlParams value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\RedirectResponseType
     */
    public function addToUrlParams(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UrlParams property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UrlParams[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedirectResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
