<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonType StructType
 * @subpackage Structs
 */
class PersonType extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Email;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Telephone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Mobile;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Fax;
    /**
     * The DateOfBirth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nationality;
    /**
     * The IdNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdNumber;
    /**
     * The IdType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdType;
    /**
     * The SocialSecurityNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SocialSecurityNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * Constructor method for PersonType
     * @uses PersonType::setFirstName()
     * @uses PersonType::setLastName()
     * @uses PersonType::setEmail()
     * @uses PersonType::setTitle()
     * @uses PersonType::setMiddleName()
     * @uses PersonType::setTelephone()
     * @uses PersonType::setMobile()
     * @uses PersonType::setFax()
     * @uses PersonType::setDateOfBirth()
     * @uses PersonType::setNationality()
     * @uses PersonType::setIdNumber()
     * @uses PersonType::setIdType()
     * @uses PersonType::setSocialSecurityNumber()
     * @uses PersonType::setAddress()
     * @param string $firstName
     * @param string $lastName
     * @param string[] $email
     * @param string $title
     * @param string $middleName
     * @param string[] $telephone
     * @param string[] $mobile
     * @param string[] $fax
     * @param string $dateOfBirth
     * @param string $nationality
     * @param string $idNumber
     * @param string $idType
     * @param string $socialSecurityNumber
     * @param \StructType\AddressType $address
     */
    public function __construct($firstName = null, $lastName = null, array $email = array(), $title = null, $middleName = null, array $telephone = array(), array $mobile = array(), array $fax = array(), $dateOfBirth = null, $nationality = null, $idNumber = null, $idType = null, $socialSecurityNumber = null, \StructType\AddressType $address = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setTitle($title)
            ->setMiddleName($middleName)
            ->setTelephone($telephone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setDateOfBirth($dateOfBirth)
            ->setNationality($nationality)
            ->setIdNumber($idNumber)
            ->setIdType($idType)
            ->setSocialSecurityNumber($socialSecurityNumber)
            ->setAddress($address);
    }
    /**
     * Get FirstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\PersonType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\PersonType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personTypeEmailItem) {
            // validation for constraint: itemType
            if (!is_string($personTypeEmailItem)) {
                $invalidValues[] = is_object($personTypeEmailItem) ? get_class($personTypeEmailItem) : sprintf('%s(%s)', gettype($personTypeEmailItem), var_export($personTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \StructType\PersonType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonType
     */
    public function addToEmail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\PersonType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\PersonType
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!is_string($personTypeTelephoneItem)) {
                $invalidValues[] = is_object($personTypeTelephoneItem) ? get_class($personTypeTelephoneItem) : sprintf('%s(%s)', gettype($personTypeTelephoneItem), var_export($personTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param string[] $telephone
     * @return \StructType\PersonType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonType
     */
    public function addToTelephone($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string[]|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * This method is responsible for validating the values passed to the setMobile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMobile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMobileForArrayConstraintsFromSetMobile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personTypeMobileItem) {
            // validation for constraint: itemType
            if (!is_string($personTypeMobileItem)) {
                $invalidValues[] = is_object($personTypeMobileItem) ? get_class($personTypeMobileItem) : sprintf('%s(%s)', gettype($personTypeMobileItem), var_export($personTypeMobileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mobile property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mobile value
     * @throws \InvalidArgumentException
     * @param string[] $mobile
     * @return \StructType\PersonType
     */
    public function setMobile(array $mobile = array())
    {
        // validation for constraint: array
        if ('' !== ($mobileArrayErrorMessage = self::validateMobileForArrayConstraintsFromSetMobile($mobile))) {
            throw new \InvalidArgumentException($mobileArrayErrorMessage, __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Add item to Mobile value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonType
     */
    public function addToMobile($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Mobile property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mobile[] = $item;
        return $this;
    }
    /**
     * Get Fax value
     * @return string[]|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * This method is responsible for validating the values passed to the setFax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFaxForArrayConstraintsFromSetFax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personTypeFaxItem) {
            // validation for constraint: itemType
            if (!is_string($personTypeFaxItem)) {
                $invalidValues[] = is_object($personTypeFaxItem) ? get_class($personTypeFaxItem) : sprintf('%s(%s)', gettype($personTypeFaxItem), var_export($personTypeFaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fax property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fax value
     * @throws \InvalidArgumentException
     * @param string[] $fax
     * @return \StructType\PersonType
     */
    public function setFax(array $fax = array())
    {
        // validation for constraint: array
        if ('' !== ($faxArrayErrorMessage = self::validateFaxForArrayConstraintsFromSetFax($fax))) {
            throw new \InvalidArgumentException($faxArrayErrorMessage, __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Add item to Fax value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PersonType
     */
    public function addToFax($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Fax property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fax[] = $item;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\PersonType
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\PersonType
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get IdNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->IdNumber;
    }
    /**
     * Set IdNumber value
     * @param string $idNumber
     * @return \StructType\PersonType
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idNumber, true), gettype($idNumber)), __LINE__);
        }
        $this->IdNumber = $idNumber;
        return $this;
    }
    /**
     * Get IdType value
     * @return string|null
     */
    public function getIdType()
    {
        return $this->IdType;
    }
    /**
     * Set IdType value
     * @param string $idType
     * @return \StructType\PersonType
     */
    public function setIdType($idType = null)
    {
        // validation for constraint: string
        if (!is_null($idType) && !is_string($idType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idType, true), gettype($idType)), __LINE__);
        }
        $this->IdType = $idType;
        return $this;
    }
    /**
     * Get SocialSecurityNumber value
     * @return string|null
     */
    public function getSocialSecurityNumber()
    {
        return $this->SocialSecurityNumber;
    }
    /**
     * Set SocialSecurityNumber value
     * @param string $socialSecurityNumber
     * @return \StructType\PersonType
     */
    public function setSocialSecurityNumber($socialSecurityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($socialSecurityNumber) && !is_string($socialSecurityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialSecurityNumber, true), gettype($socialSecurityNumber)), __LINE__);
        }
        $this->SocialSecurityNumber = $socialSecurityNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\PersonType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
