<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayGateAccountType StructType
 * @subpackage Structs
 */
class PayGateAccountType extends AbstractStructBase
{
    /**
     * The PayGateId
     * @var string
     */
    public $PayGateId;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for PayGateAccountType
     * @uses PayGateAccountType::setPayGateId()
     * @uses PayGateAccountType::setPassword()
     * @param string $payGateId
     * @param string $password
     */
    public function __construct($payGateId = null, $password = null)
    {
        $this
            ->setPayGateId($payGateId)
            ->setPassword($password);
    }
    /**
     * Get PayGateId value
     * @return string|null
     */
    public function getPayGateId()
    {
        return $this->PayGateId;
    }
    /**
     * Set PayGateId value
     * @param string $payGateId
     * @return \StructType\PayGateAccountType
     */
    public function setPayGateId($payGateId = null)
    {
        // validation for constraint: string
        if (!is_null($payGateId) && !is_string($payGateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payGateId, true), gettype($payGateId)), __LINE__);
        }
        $this->PayGateId = $payGateId;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\PayGateAccountType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PayGateAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
