<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardVaultRequestType StructType
 * @subpackage Structs
 */
class CardVaultRequestType extends AbstractStructBase
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 19
     * - maxOccurs: 1
     * - minLength: 13
     * - minOccurs: 1
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The CardExpiryDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for CardVaultRequestType
     * @uses CardVaultRequestType::setCardNumber()
     * @uses CardVaultRequestType::setAccount()
     * @uses CardVaultRequestType::setCardExpiryDate()
     * @uses CardVaultRequestType::setUserDefinedFields()
     * @param string $cardNumber
     * @param \StructType\PayGateAccountType $account
     * @param string $cardExpiryDate
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct($cardNumber = null, \StructType\PayGateAccountType $account = null, $cardExpiryDate = null, array $userDefinedFields = array())
    {
        $this
            ->setCardNumber($cardNumber)
            ->setAccount($account)
            ->setCardExpiryDate($cardExpiryDate)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\CardVaultRequestType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9x]+)
        if (!is_null($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9x]+', var_export($cardNumber, true)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\CardVaultRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string|null
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\CardVaultRequestType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiryDate, true), gettype($cardExpiryDate)), __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($cardExpiryDate, true)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cardVaultRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$cardVaultRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($cardVaultRequestTypeUserDefinedFieldsItem) ? get_class($cardVaultRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($cardVaultRequestTypeUserDefinedFieldsItem), var_export($cardVaultRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\CardVaultRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\CardVaultRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardVaultRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
