<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingDetailsType StructType
 * @subpackage Structs
 */
class BillingDetailsType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * Constructor method for BillingDetailsType
     * @uses BillingDetailsType::setCustomer()
     * @uses BillingDetailsType::setAddress()
     * @param \StructType\PersonType $customer
     * @param \StructType\AddressType $address
     */
    public function __construct(\StructType\PersonType $customer = null, \StructType\AddressType $address = null)
    {
        $this
            ->setCustomer($customer)
            ->setAddress($address);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\BillingDetailsType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\BillingDetailsType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
