<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcquirerInfoType StructType
 * @subpackage Structs
 */
class AcquirerInfoType extends AbstractStructBase
{
    /**
     * The MCC
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $MCC;
    /**
     * Constructor method for AcquirerInfoType
     * @uses AcquirerInfoType::setMCC()
     * @param string $mCC
     */
    public function __construct($mCC = null)
    {
        $this
            ->setMCC($mCC);
    }
    /**
     * Get MCC value
     * @return string|null
     */
    public function getMCC()
    {
        return $this->MCC;
    }
    /**
     * Set MCC value
     * @param string $mCC
     * @return \StructType\AcquirerInfoType
     */
    public function setMCC($mCC = null)
    {
        // validation for constraint: string
        if (!is_null($mCC) && !is_string($mCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mCC, true), gettype($mCC)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($mCC) && mb_strlen($mCC) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($mCC)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($mCC) && mb_strlen($mCC) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($mCC)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($mCC) && !preg_match('/[0-9]+/', $mCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($mCC, true)), __LINE__);
        }
        $this->MCC = $mCC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcquirerInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
