<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePaymentResponse StructType
 * @subpackage Structs
 */
class SinglePaymentResponse extends AbstractStructBase
{
    /**
     * The CardPaymentResponse
     * @var \StructType\CardPaymentResponseType
     */
    public $CardPaymentResponse;
    /**
     * The WebPaymentResponse
     * @var \StructType\WebPaymentResponseType
     */
    public $WebPaymentResponse;
    /**
     * The TokenPaymentResponse
     * @var \StructType\TokenPaymentResponseType
     */
    public $TokenPaymentResponse;
    /**
     * The BankPaymentResponse
     * @var \StructType\BankPaymentResponseType
     */
    public $BankPaymentResponse;
    /**
     * Constructor method for SinglePaymentResponse
     * @uses SinglePaymentResponse::setCardPaymentResponse()
     * @uses SinglePaymentResponse::setWebPaymentResponse()
     * @uses SinglePaymentResponse::setTokenPaymentResponse()
     * @uses SinglePaymentResponse::setBankPaymentResponse()
     * @param \StructType\CardPaymentResponseType $cardPaymentResponse
     * @param \StructType\WebPaymentResponseType $webPaymentResponse
     * @param \StructType\TokenPaymentResponseType $tokenPaymentResponse
     * @param \StructType\BankPaymentResponseType $bankPaymentResponse
     */
    public function __construct(\StructType\CardPaymentResponseType $cardPaymentResponse = null, \StructType\WebPaymentResponseType $webPaymentResponse = null, \StructType\TokenPaymentResponseType $tokenPaymentResponse = null, \StructType\BankPaymentResponseType $bankPaymentResponse = null)
    {
        $this
            ->setCardPaymentResponse($cardPaymentResponse)
            ->setWebPaymentResponse($webPaymentResponse)
            ->setTokenPaymentResponse($tokenPaymentResponse)
            ->setBankPaymentResponse($bankPaymentResponse);
    }
    /**
     * Get CardPaymentResponse value
     * @return \StructType\CardPaymentResponseType|null
     */
    public function getCardPaymentResponse()
    {
        return $this->CardPaymentResponse;
    }
    /**
     * Set CardPaymentResponse value
     * @param \StructType\CardPaymentResponseType $cardPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setCardPaymentResponse(\StructType\CardPaymentResponseType $cardPaymentResponse = null)
    {
        $this->CardPaymentResponse = $cardPaymentResponse;
        return $this;
    }
    /**
     * Get WebPaymentResponse value
     * @return \StructType\WebPaymentResponseType|null
     */
    public function getWebPaymentResponse()
    {
        return $this->WebPaymentResponse;
    }
    /**
     * Set WebPaymentResponse value
     * @param \StructType\WebPaymentResponseType $webPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setWebPaymentResponse(\StructType\WebPaymentResponseType $webPaymentResponse = null)
    {
        $this->WebPaymentResponse = $webPaymentResponse;
        return $this;
    }
    /**
     * Get TokenPaymentResponse value
     * @return \StructType\TokenPaymentResponseType|null
     */
    public function getTokenPaymentResponse()
    {
        return $this->TokenPaymentResponse;
    }
    /**
     * Set TokenPaymentResponse value
     * @param \StructType\TokenPaymentResponseType $tokenPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setTokenPaymentResponse(\StructType\TokenPaymentResponseType $tokenPaymentResponse = null)
    {
        $this->TokenPaymentResponse = $tokenPaymentResponse;
        return $this;
    }
    /**
     * Get BankPaymentResponse value
     * @return \StructType\BankPaymentResponseType|null
     */
    public function getBankPaymentResponse()
    {
        return $this->BankPaymentResponse;
    }
    /**
     * Set BankPaymentResponse value
     * @param \StructType\BankPaymentResponseType $bankPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setBankPaymentResponse(\StructType\BankPaymentResponseType $bankPaymentResponse = null)
    {
        $this->BankPaymentResponse = $bankPaymentResponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SinglePaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
