<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardPayoutRequestType StructType
 * @subpackage Structs
 */
class CardPayoutRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 19
     * - minLength: 13
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The CardExpiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The CVV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 4
     * - minLength: 3
     * - pattern: [0-9]+
     * @var string
     */
    public $CVV;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for CardPayoutRequestType
     * @uses CardPayoutRequestType::setCustomer()
     * @uses CardPayoutRequestType::setCardNumber()
     * @uses CardPayoutRequestType::setCardExpiryDate()
     * @uses CardPayoutRequestType::setAccount()
     * @uses CardPayoutRequestType::setCVV()
     * @uses CardPayoutRequestType::setOrder()
     * @uses CardPayoutRequestType::setUserDefinedFields()
     * @param \StructType\PersonType $customer
     * @param string $cardNumber
     * @param string $cardExpiryDate
     * @param \StructType\PayGateAccountType $account
     * @param string $cVV
     * @param \StructType\OrderType $order
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\PersonType $customer = null, $cardNumber = null, $cardExpiryDate = null, \StructType\PayGateAccountType $account = null, $cVV = null, \StructType\OrderType $order = null, array $userDefinedFields = array())
    {
        $this
            ->setCustomer($customer)
            ->setCardNumber($cardNumber)
            ->setCardExpiryDate($cardExpiryDate)
            ->setAccount($account)
            ->setCVV($cVV)
            ->setOrder($order)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\CardPayoutRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\CardPayoutRequestType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardNumber) && strlen($cardNumber) > 19) || (is_array($cardNumber) && count($cardNumber) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($cardNumber) ? strlen($cardNumber) : count($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardNumber) && strlen($cardNumber) < 13) || (is_array($cardNumber) && count($cardNumber) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9x]+", "%s" given', var_export($cardNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\CardPayoutRequestType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0][0-9]|[1][0-2])20[0-9]{2}", "%s" given', var_export($cardExpiryDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardExpiryDate)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\CardPayoutRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CVV value
     * @return string|null
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \StructType\CardPayoutRequestType
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cVV) && strlen($cVV) > 4) || (is_array($cVV) && count($cVV) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($cVV) ? strlen($cVV) : count($cVV)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cVV) && strlen($cVV) < 3) || (is_array($cVV) && count($cVV) < 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($cVV) && !preg_match('/[0-9]+/', $cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]+", "%s" given', var_export($cVV, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cVV)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\CardPayoutRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\CardPayoutRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $cardPayoutRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$cardPayoutRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($cardPayoutRequestTypeUserDefinedFieldsItem) ? get_class($cardPayoutRequestTypeUserDefinedFieldsItem) : gettype($cardPayoutRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\CardPayoutRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardPayoutRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
