<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardPaymentRequestType StructType
 * @subpackage Structs
 */
class CardPaymentRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 19
     * - minLength: 13
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The VaultId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VaultId;
    /**
     * The CVV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 4
     * - minLength: 3
     * - pattern: [0-9]+
     * @var string
     */
    public $CVV;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The CardExpiryDate
     * Meta informations extracted from the WSDL
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The CardIssueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardIssueDate;
    /**
     * The CardIssueNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * - pattern: [0-9]+
     * @var string
     */
    public $CardIssueNumber;
    /**
     * The Vault
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The BudgetPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 2
     * - minLength: 1
     * - pattern: [0-9]+
     * @var string
     */
    public $BudgetPeriod;
    /**
     * The Redirect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The ThreeDSecure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureType
     */
    public $ThreeDSecure;
    /**
     * The Risk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskType
     */
    public $Risk;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * The BillingDescriptor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * Constructor method for CardPaymentRequestType
     * @uses CardPaymentRequestType::setCustomer()
     * @uses CardPaymentRequestType::setCardNumber()
     * @uses CardPaymentRequestType::setVaultId()
     * @uses CardPaymentRequestType::setCVV()
     * @uses CardPaymentRequestType::setAccount()
     * @uses CardPaymentRequestType::setCardExpiryDate()
     * @uses CardPaymentRequestType::setCardIssueDate()
     * @uses CardPaymentRequestType::setCardIssueNumber()
     * @uses CardPaymentRequestType::setVault()
     * @uses CardPaymentRequestType::setBudgetPeriod()
     * @uses CardPaymentRequestType::setRedirect()
     * @uses CardPaymentRequestType::setOrder()
     * @uses CardPaymentRequestType::setThreeDSecure()
     * @uses CardPaymentRequestType::setRisk()
     * @uses CardPaymentRequestType::setUserDefinedFields()
     * @uses CardPaymentRequestType::setBillingDescriptor()
     * @param \StructType\PersonType $customer
     * @param string $cardNumber
     * @param string $vaultId
     * @param string $cVV
     * @param \StructType\PayGateAccountType $account
     * @param string $cardExpiryDate
     * @param string $cardIssueDate
     * @param string $cardIssueNumber
     * @param bool $vault
     * @param string $budgetPeriod
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @param \StructType\RiskType $risk
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @param string $billingDescriptor
     */
    public function __construct(\StructType\PersonType $customer = null, $cardNumber = null, $vaultId = null, $cVV = null, \StructType\PayGateAccountType $account = null, $cardExpiryDate = null, $cardIssueDate = null, $cardIssueNumber = null, $vault = false, $budgetPeriod = null, \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\ThreeDSecureType $threeDSecure = null, \StructType\RiskType $risk = null, array $userDefinedFields = array(), $billingDescriptor = null)
    {
        $this
            ->setCustomer($customer)
            ->setCardNumber($cardNumber)
            ->setVaultId($vaultId)
            ->setCVV($cVV)
            ->setAccount($account)
            ->setCardExpiryDate($cardExpiryDate)
            ->setCardIssueDate($cardIssueDate)
            ->setCardIssueNumber($cardIssueNumber)
            ->setVault($vault)
            ->setBudgetPeriod($budgetPeriod)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setThreeDSecure($threeDSecure)
            ->setRisk($risk)
            ->setUserDefinedFields($userDefinedFields)
            ->setBillingDescriptor($billingDescriptor);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\CardPaymentRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardNumber) && strlen($cardNumber) > 19) || (is_array($cardNumber) && count($cardNumber) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($cardNumber) ? strlen($cardNumber) : count($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardNumber) && strlen($cardNumber) < 13) || (is_array($cardNumber) && count($cardNumber) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9x]+", "%s" given', var_export($cardNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get VaultId value
     * @return string
     */
    public function getVaultId()
    {
        return $this->VaultId;
    }
    /**
     * Set VaultId value
     * @param string $vaultId
     * @return \StructType\CardPaymentRequestType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vaultId)), __LINE__);
        }
        $this->VaultId = $vaultId;
        return $this;
    }
    /**
     * Get CVV value
     * @return string
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \StructType\CardPaymentRequestType
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cVV) && strlen($cVV) > 4) || (is_array($cVV) && count($cVV) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($cVV) ? strlen($cVV) : count($cVV)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cVV) && strlen($cVV) < 3) || (is_array($cVV) && count($cVV) < 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($cVV) && !preg_match('/[0-9]+/', $cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]+", "%s" given', var_export($cVV, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cVV)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\CardPaymentRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string|null
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0][0-9]|[1][0-2])20[0-9]{2}", "%s" given', var_export($cardExpiryDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardExpiryDate)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get CardIssueDate value
     * @return string|null
     */
    public function getCardIssueDate()
    {
        return $this->CardIssueDate;
    }
    /**
     * Set CardIssueDate value
     * @param string $cardIssueDate
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardIssueDate($cardIssueDate = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cardIssueDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0][0-9]|[1][0-2])20[0-9]{2}", "%s" given', var_export($cardIssueDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardIssueDate) && !is_string($cardIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardIssueDate)), __LINE__);
        }
        $this->CardIssueDate = $cardIssueDate;
        return $this;
    }
    /**
     * Get CardIssueNumber value
     * @return string|null
     */
    public function getCardIssueNumber()
    {
        return $this->CardIssueNumber;
    }
    /**
     * Set CardIssueNumber value
     * @param string $cardIssueNumber
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardIssueNumber($cardIssueNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardIssueNumber) && strlen($cardIssueNumber) > 3) || (is_array($cardIssueNumber) && count($cardIssueNumber) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($cardIssueNumber) ? strlen($cardIssueNumber) : count($cardIssueNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardIssueNumber) && strlen($cardIssueNumber) < 1) || (is_array($cardIssueNumber) && count($cardIssueNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($cardIssueNumber) && !preg_match('/[0-9]+/', $cardIssueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]+", "%s" given', var_export($cardIssueNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardIssueNumber) && !is_string($cardIssueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardIssueNumber)), __LINE__);
        }
        $this->CardIssueNumber = $cardIssueNumber;
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\CardPaymentRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get BudgetPeriod value
     * @return string|null
     */
    public function getBudgetPeriod()
    {
        return $this->BudgetPeriod;
    }
    /**
     * Set BudgetPeriod value
     * @param string $budgetPeriod
     * @return \StructType\CardPaymentRequestType
     */
    public function setBudgetPeriod($budgetPeriod = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($budgetPeriod) && strlen($budgetPeriod) > 2) || (is_array($budgetPeriod) && count($budgetPeriod) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($budgetPeriod) ? strlen($budgetPeriod) : count($budgetPeriod)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($budgetPeriod) && strlen($budgetPeriod) < 1) || (is_array($budgetPeriod) && count($budgetPeriod) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($budgetPeriod) && !preg_match('/[0-9]+/', $budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]+", "%s" given', var_export($budgetPeriod, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($budgetPeriod) && !is_string($budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($budgetPeriod)), __LINE__);
        }
        $this->BudgetPeriod = $budgetPeriod;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\CardPaymentRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\CardPaymentRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ThreeDSecure value
     * @return \StructType\ThreeDSecureType|null
     */
    public function getThreeDSecure()
    {
        return $this->ThreeDSecure;
    }
    /**
     * Set ThreeDSecure value
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @return \StructType\CardPaymentRequestType
     */
    public function setThreeDSecure(\StructType\ThreeDSecureType $threeDSecure = null)
    {
        $this->ThreeDSecure = $threeDSecure;
        return $this;
    }
    /**
     * Get Risk value
     * @return \StructType\RiskType|null
     */
    public function getRisk()
    {
        return $this->Risk;
    }
    /**
     * Set Risk value
     * @param \StructType\RiskType $risk
     * @return \StructType\CardPaymentRequestType
     */
    public function setRisk(\StructType\RiskType $risk = null)
    {
        $this->Risk = $risk;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\CardPaymentRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $cardPaymentRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$cardPaymentRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($cardPaymentRequestTypeUserDefinedFieldsItem) ? get_class($cardPaymentRequestTypeUserDefinedFieldsItem) : gettype($cardPaymentRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\CardPaymentRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\CardPaymentRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardPaymentRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
