<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrowserType StructType
 * @subpackage Structs
 */
class BrowserType extends AbstractStructBase
{
    /**
     * The UserAgent
     * @var string
     */
    public $UserAgent;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - pattern: ([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*
     * @var string
     */
    public $Language;
    /**
     * Constructor method for BrowserType
     * @uses BrowserType::setUserAgent()
     * @uses BrowserType::setLanguage()
     * @param string $userAgent
     * @param string $language
     */
    public function __construct($userAgent = null, $language = null)
    {
        $this
            ->setUserAgent($userAgent)
            ->setLanguage($language);
    }
    /**
     * Get UserAgent value
     * @return string|null
     */
    public function getUserAgent()
    {
        return $this->UserAgent;
    }
    /**
     * Set UserAgent value
     * @param string $userAgent
     * @return \StructType\BrowserType
     */
    public function setUserAgent($userAgent = null)
    {
        // validation for constraint: string
        if (!is_null($userAgent) && !is_string($userAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userAgent)), __LINE__);
        }
        $this->UserAgent = $userAgent;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\BrowserType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: pattern
        if (is_scalar($language) && !preg_match('/([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*/', $language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*", "%s" given', var_export($language, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BrowserType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
