<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusType StructType
 * @subpackage Structs
 */
class StatusType extends AbstractStructBase
{
    /**
     * The TransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The AcquirerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcquirerCode;
    /**
     * The StatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusName;
    /**
     * The StatusDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDetail;
    /**
     * The AuthCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The PayRequestId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayRequestId;
    /**
     * The VaultId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VaultId;
    /**
     * The PayVaultData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VaultDataType[]
     */
    public $PayVaultData;
    /**
     * The TransactionStatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The TransactionStatusDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionStatusDescription;
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultDescription;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * The RequestedCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestedCurrency;
    /**
     * The RequestedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $RequestedAmount;
    /**
     * The ConversionRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConversionRate;
    /**
     * The RiskIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RiskIndicator;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentType
     */
    public $PaymentType;
    /**
     * The BillingDescriptor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionType;
    /**
     * Constructor method for StatusType
     * @uses StatusType::setTransactionId()
     * @uses StatusType::setReference()
     * @uses StatusType::setAcquirerCode()
     * @uses StatusType::setStatusName()
     * @uses StatusType::setStatusDetail()
     * @uses StatusType::setAuthCode()
     * @uses StatusType::setPayRequestId()
     * @uses StatusType::setVaultId()
     * @uses StatusType::setPayVaultData()
     * @uses StatusType::setTransactionStatusCode()
     * @uses StatusType::setTransactionStatusDescription()
     * @uses StatusType::setResultCode()
     * @uses StatusType::setResultDescription()
     * @uses StatusType::setCurrency()
     * @uses StatusType::setAmount()
     * @uses StatusType::setRequestedCurrency()
     * @uses StatusType::setRequestedAmount()
     * @uses StatusType::setConversionRate()
     * @uses StatusType::setRiskIndicator()
     * @uses StatusType::setPaymentType()
     * @uses StatusType::setBillingDescriptor()
     * @uses StatusType::setDateTime()
     * @uses StatusType::setTransactionType()
     * @param string $transactionId
     * @param string $reference
     * @param string $acquirerCode
     * @param string $statusName
     * @param string $statusDetail
     * @param string $authCode
     * @param string $payRequestId
     * @param string $vaultId
     * @param \StructType\VaultDataType[] $payVaultData
     * @param string $transactionStatusCode
     * @param string $transactionStatusDescription
     * @param string $resultCode
     * @param string $resultDescription
     * @param string $currency
     * @param int $amount
     * @param string $requestedCurrency
     * @param int $requestedAmount
     * @param string $conversionRate
     * @param string $riskIndicator
     * @param \StructType\PaymentType $paymentType
     * @param string $billingDescriptor
     * @param string $dateTime
     * @param string $transactionType
     */
    public function __construct($transactionId = null, $reference = null, $acquirerCode = null, $statusName = null, $statusDetail = null, $authCode = null, $payRequestId = null, $vaultId = null, array $payVaultData = array(), $transactionStatusCode = null, $transactionStatusDescription = null, $resultCode = null, $resultDescription = null, $currency = null, $amount = null, $requestedCurrency = null, $requestedAmount = null, $conversionRate = null, $riskIndicator = null, \StructType\PaymentType $paymentType = null, $billingDescriptor = null, $dateTime = null, $transactionType = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setReference($reference)
            ->setAcquirerCode($acquirerCode)
            ->setStatusName($statusName)
            ->setStatusDetail($statusDetail)
            ->setAuthCode($authCode)
            ->setPayRequestId($payRequestId)
            ->setVaultId($vaultId)
            ->setPayVaultData($payVaultData)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setTransactionStatusDescription($transactionStatusDescription)
            ->setResultCode($resultCode)
            ->setResultDescription($resultDescription)
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setRequestedCurrency($requestedCurrency)
            ->setRequestedAmount($requestedAmount)
            ->setConversionRate($conversionRate)
            ->setRiskIndicator($riskIndicator)
            ->setPaymentType($paymentType)
            ->setBillingDescriptor($billingDescriptor)
            ->setDateTime($dateTime)
            ->setTransactionType($transactionType);
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\StatusType
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\StatusType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get AcquirerCode value
     * @return string|null
     */
    public function getAcquirerCode()
    {
        return $this->AcquirerCode;
    }
    /**
     * Set AcquirerCode value
     * @param string $acquirerCode
     * @return \StructType\StatusType
     */
    public function setAcquirerCode($acquirerCode = null)
    {
        // validation for constraint: string
        if (!is_null($acquirerCode) && !is_string($acquirerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acquirerCode)), __LINE__);
        }
        $this->AcquirerCode = $acquirerCode;
        return $this;
    }
    /**
     * Get StatusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->StatusName;
    }
    /**
     * Set StatusName value
     * @uses \EnumType\StatusNameType::valueIsValid()
     * @uses \EnumType\StatusNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusName
     * @return \StructType\StatusType
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusNameType::valueIsValid($statusName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $statusName, implode(', ', \EnumType\StatusNameType::getValidValues())), __LINE__);
        }
        $this->StatusName = $statusName;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return string|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param string $statusDetail
     * @return \StructType\StatusType
     */
    public function setStatusDetail($statusDetail = null)
    {
        // validation for constraint: string
        if (!is_null($statusDetail) && !is_string($statusDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDetail)), __LINE__);
        }
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\StatusType
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get PayRequestId value
     * @return string|null
     */
    public function getPayRequestId()
    {
        return $this->PayRequestId;
    }
    /**
     * Set PayRequestId value
     * @param string $payRequestId
     * @return \StructType\StatusType
     */
    public function setPayRequestId($payRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($payRequestId) && !is_string($payRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payRequestId)), __LINE__);
        }
        $this->PayRequestId = $payRequestId;
        return $this;
    }
    /**
     * Get VaultId value
     * @return string|null
     */
    public function getVaultId()
    {
        return $this->VaultId;
    }
    /**
     * Set VaultId value
     * @param string $vaultId
     * @return \StructType\StatusType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vaultId)), __LINE__);
        }
        $this->VaultId = $vaultId;
        return $this;
    }
    /**
     * Get PayVaultData value
     * @return \StructType\VaultDataType[]|null
     */
    public function getPayVaultData()
    {
        return $this->PayVaultData;
    }
    /**
     * Set PayVaultData value
     * @throws \InvalidArgumentException
     * @param \StructType\VaultDataType[] $payVaultData
     * @return \StructType\StatusType
     */
    public function setPayVaultData(array $payVaultData = array())
    {
        foreach ($payVaultData as $statusTypePayVaultDataItem) {
            // validation for constraint: itemType
            if (!$statusTypePayVaultDataItem instanceof \StructType\VaultDataType) {
                throw new \InvalidArgumentException(sprintf('The PayVaultData property can only contain items of \StructType\VaultDataType, "%s" given', is_object($statusTypePayVaultDataItem) ? get_class($statusTypePayVaultDataItem) : gettype($statusTypePayVaultDataItem)), __LINE__);
            }
        }
        $this->PayVaultData = $payVaultData;
        return $this;
    }
    /**
     * Add item to PayVaultData value
     * @throws \InvalidArgumentException
     * @param \StructType\VaultDataType $item
     * @return \StructType\StatusType
     */
    public function addToPayVaultData(\StructType\VaultDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VaultDataType) {
            throw new \InvalidArgumentException(sprintf('The PayVaultData property can only contain items of \StructType\VaultDataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PayVaultData[] = $item;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\StatusType
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get TransactionStatusDescription value
     * @return string|null
     */
    public function getTransactionStatusDescription()
    {
        return $this->TransactionStatusDescription;
    }
    /**
     * Set TransactionStatusDescription value
     * @param string $transactionStatusDescription
     * @return \StructType\StatusType
     */
    public function setTransactionStatusDescription($transactionStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusDescription) && !is_string($transactionStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusDescription)), __LINE__);
        }
        $this->TransactionStatusDescription = $transactionStatusDescription;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\StatusType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultDescription value
     * @return string|null
     */
    public function getResultDescription()
    {
        return $this->ResultDescription;
    }
    /**
     * Set ResultDescription value
     * @param string $resultDescription
     * @return \StructType\StatusType
     */
    public function setResultDescription($resultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($resultDescription) && !is_string($resultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultDescription)), __LINE__);
        }
        $this->ResultDescription = $resultDescription;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\StatusType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\StatusType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get RequestedCurrency value
     * @return string|null
     */
    public function getRequestedCurrency()
    {
        return $this->RequestedCurrency;
    }
    /**
     * Set RequestedCurrency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedCurrency
     * @return \StructType\StatusType
     */
    public function setRequestedCurrency($requestedCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($requestedCurrency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestedCurrency, implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->RequestedCurrency = $requestedCurrency;
        return $this;
    }
    /**
     * Get RequestedAmount value
     * @return int|null
     */
    public function getRequestedAmount()
    {
        return $this->RequestedAmount;
    }
    /**
     * Set RequestedAmount value
     * @param int $requestedAmount
     * @return \StructType\StatusType
     */
    public function setRequestedAmount($requestedAmount = null)
    {
        // validation for constraint: int
        if (!is_null($requestedAmount) && !is_numeric($requestedAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestedAmount)), __LINE__);
        }
        $this->RequestedAmount = $requestedAmount;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return string|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param string $conversionRate
     * @return \StructType\StatusType
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: string
        if (!is_null($conversionRate) && !is_string($conversionRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get RiskIndicator value
     * @return string|null
     */
    public function getRiskIndicator()
    {
        return $this->RiskIndicator;
    }
    /**
     * Set RiskIndicator value
     * @param string $riskIndicator
     * @return \StructType\StatusType
     */
    public function setRiskIndicator($riskIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($riskIndicator) && !is_string($riskIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($riskIndicator)), __LINE__);
        }
        $this->RiskIndicator = $riskIndicator;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return \StructType\PaymentType|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param \StructType\PaymentType $paymentType
     * @return \StructType\StatusType
     */
    public function setPaymentType(\StructType\PaymentType $paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\StatusType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\StatusType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\StatusType
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionType, implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
