<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleVaultRequest StructType
 * @subpackage Structs
 */
class SingleVaultRequest extends AbstractStructBase
{
    /**
     * The CardVaultRequest
     * @var \StructType\CardVaultRequestType
     */
    public $CardVaultRequest;
    /**
     * The WalletVaultRequest
     * @var \StructType\WalletVaultRequestType
     */
    public $WalletVaultRequest;
    /**
     * The LookUpVaultRequest
     * @var \StructType\LookUpVaultRequestType
     */
    public $LookUpVaultRequest;
    /**
     * The DeleteVaultRequest
     * @var \StructType\DeleteVaultRequestType
     */
    public $DeleteVaultRequest;
    /**
     * Constructor method for SingleVaultRequest
     * @uses SingleVaultRequest::setCardVaultRequest()
     * @uses SingleVaultRequest::setWalletVaultRequest()
     * @uses SingleVaultRequest::setLookUpVaultRequest()
     * @uses SingleVaultRequest::setDeleteVaultRequest()
     * @param \StructType\CardVaultRequestType $cardVaultRequest
     * @param \StructType\WalletVaultRequestType $walletVaultRequest
     * @param \StructType\LookUpVaultRequestType $lookUpVaultRequest
     * @param \StructType\DeleteVaultRequestType $deleteVaultRequest
     */
    public function __construct(\StructType\CardVaultRequestType $cardVaultRequest = null, \StructType\WalletVaultRequestType $walletVaultRequest = null, \StructType\LookUpVaultRequestType $lookUpVaultRequest = null, \StructType\DeleteVaultRequestType $deleteVaultRequest = null)
    {
        $this
            ->setCardVaultRequest($cardVaultRequest)
            ->setWalletVaultRequest($walletVaultRequest)
            ->setLookUpVaultRequest($lookUpVaultRequest)
            ->setDeleteVaultRequest($deleteVaultRequest);
    }
    /**
     * Get CardVaultRequest value
     * @return \StructType\CardVaultRequestType|null
     */
    public function getCardVaultRequest()
    {
        return $this->CardVaultRequest;
    }
    /**
     * Set CardVaultRequest value
     * @param \StructType\CardVaultRequestType $cardVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setCardVaultRequest(\StructType\CardVaultRequestType $cardVaultRequest = null)
    {
        $this->CardVaultRequest = $cardVaultRequest;
        return $this;
    }
    /**
     * Get WalletVaultRequest value
     * @return \StructType\WalletVaultRequestType|null
     */
    public function getWalletVaultRequest()
    {
        return $this->WalletVaultRequest;
    }
    /**
     * Set WalletVaultRequest value
     * @param \StructType\WalletVaultRequestType $walletVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setWalletVaultRequest(\StructType\WalletVaultRequestType $walletVaultRequest = null)
    {
        $this->WalletVaultRequest = $walletVaultRequest;
        return $this;
    }
    /**
     * Get LookUpVaultRequest value
     * @return \StructType\LookUpVaultRequestType|null
     */
    public function getLookUpVaultRequest()
    {
        return $this->LookUpVaultRequest;
    }
    /**
     * Set LookUpVaultRequest value
     * @param \StructType\LookUpVaultRequestType $lookUpVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setLookUpVaultRequest(\StructType\LookUpVaultRequestType $lookUpVaultRequest = null)
    {
        $this->LookUpVaultRequest = $lookUpVaultRequest;
        return $this;
    }
    /**
     * Get DeleteVaultRequest value
     * @return \StructType\DeleteVaultRequestType|null
     */
    public function getDeleteVaultRequest()
    {
        return $this->DeleteVaultRequest;
    }
    /**
     * Set DeleteVaultRequest value
     * @param \StructType\DeleteVaultRequestType $deleteVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setDeleteVaultRequest(\StructType\DeleteVaultRequestType $deleteVaultRequest = null)
    {
        $this->DeleteVaultRequest = $deleteVaultRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SingleVaultRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
