<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemType StructType
 * @subpackage Structs
 */
class OrderItemType extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDescription;
    /**
     * The ProductCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCategory;
    /**
     * The ProductRisk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductRisk;
    /**
     * The OrderQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrderQuantity;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $UnitPrice;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for OrderItemType
     * @uses OrderItemType::setProductCode()
     * @uses OrderItemType::setProductDescription()
     * @uses OrderItemType::setProductCategory()
     * @uses OrderItemType::setProductRisk()
     * @uses OrderItemType::setOrderQuantity()
     * @uses OrderItemType::setUnitPrice()
     * @uses OrderItemType::setCurrency()
     * @param string $productCode
     * @param string $productDescription
     * @param string $productCategory
     * @param string $productRisk
     * @param int $orderQuantity
     * @param float $unitPrice
     * @param string $currency
     */
    public function __construct($productCode = null, $productDescription = null, $productCategory = null, $productRisk = null, $orderQuantity = null, $unitPrice = null, $currency = null)
    {
        $this
            ->setProductCode($productCode)
            ->setProductDescription($productDescription)
            ->setProductCategory($productCategory)
            ->setProductRisk($productRisk)
            ->setOrderQuantity($orderQuantity)
            ->setUnitPrice($unitPrice)
            ->setCurrency($currency);
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\OrderItemType
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \StructType\OrderItemType
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Get ProductCategory value
     * @return string|null
     */
    public function getProductCategory()
    {
        return $this->ProductCategory;
    }
    /**
     * Set ProductCategory value
     * @param string $productCategory
     * @return \StructType\OrderItemType
     */
    public function setProductCategory($productCategory = null)
    {
        // validation for constraint: string
        if (!is_null($productCategory) && !is_string($productCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCategory)), __LINE__);
        }
        $this->ProductCategory = $productCategory;
        return $this;
    }
    /**
     * Get ProductRisk value
     * @return string|null
     */
    public function getProductRisk()
    {
        return $this->ProductRisk;
    }
    /**
     * Set ProductRisk value
     * @param string $productRisk
     * @return \StructType\OrderItemType
     */
    public function setProductRisk($productRisk = null)
    {
        // validation for constraint: string
        if (!is_null($productRisk) && !is_string($productRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productRisk)), __LINE__);
        }
        $this->ProductRisk = $productRisk;
        return $this;
    }
    /**
     * Get OrderQuantity value
     * @return int|null
     */
    public function getOrderQuantity()
    {
        return $this->OrderQuantity;
    }
    /**
     * Set OrderQuantity value
     * @param int $orderQuantity
     * @return \StructType\OrderItemType
     */
    public function setOrderQuantity($orderQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($orderQuantity) && !is_numeric($orderQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderQuantity)), __LINE__);
        }
        $this->OrderQuantity = $orderQuantity;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\OrderItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\OrderItemType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
