<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardVaultRequestType StructType
 * @subpackage Structs
 */
class CardVaultRequestType extends AbstractStructBase
{
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 19
     * - minLength: 13
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The CardExpiryDate
     * Meta informations extracted from the WSDL
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for CardVaultRequestType
     * @uses CardVaultRequestType::setCardNumber()
     * @uses CardVaultRequestType::setAccount()
     * @uses CardVaultRequestType::setCardExpiryDate()
     * @uses CardVaultRequestType::setUserDefinedFields()
     * @param string $cardNumber
     * @param \StructType\PayGateAccountType $account
     * @param string $cardExpiryDate
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct($cardNumber = null, \StructType\PayGateAccountType $account = null, $cardExpiryDate = null, array $userDefinedFields = array())
    {
        $this
            ->setCardNumber($cardNumber)
            ->setAccount($account)
            ->setCardExpiryDate($cardExpiryDate)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\CardVaultRequestType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cardNumber) && strlen($cardNumber) > 19) || (is_array($cardNumber) && count($cardNumber) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($cardNumber) ? strlen($cardNumber) : count($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cardNumber) && strlen($cardNumber) < 13) || (is_array($cardNumber) && count($cardNumber) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9x]+", "%s" given', var_export($cardNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\CardVaultRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string|null
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\CardVaultRequestType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0][0-9]|[1][0-2])20[0-9]{2}", "%s" given', var_export($cardExpiryDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardExpiryDate)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\CardVaultRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $cardVaultRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$cardVaultRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($cardVaultRequestTypeUserDefinedFieldsItem) ? get_class($cardVaultRequestTypeUserDefinedFieldsItem) : gettype($cardVaultRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\CardVaultRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardVaultRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
