<?php

namespace EnumType;

/**
 * This class stands for VaultKeyType EnumType
 * @subpackage Enumerations
 */
class VaultKeyType
{
    /**
     * Constant for value 'cardNumber'
     * @return string 'cardNumber'
     */
    const VALUE_CARD_NUMBER = 'cardNumber';
    /**
     * Constant for value 'expDate'
     * @return string 'expDate'
     */
    const VALUE_EXP_DATE = 'expDate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CARD_NUMBER
     * @uses self::VALUE_EXP_DATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CARD_NUMBER,
            self::VALUE_EXP_DATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
