<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentType StructType
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The Method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Method;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $Detail;
    /**
     * Constructor method for PaymentType
     * @uses PaymentType::setMethod()
     * @uses PaymentType::setDetail()
     * @param string $method
     * @param string $detail
     */
    public function __construct($method = null, $detail = null)
    {
        $this
            ->setMethod($method)
            ->setDetail($detail);
    }
    /**
     * Get Method value
     * @return string
     */
    public function getMethod()
    {
        return $this->Method;
    }
    /**
     * Set Method value
     * @uses \EnumType\PaymentMethodType::valueIsValid()
     * @uses \EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return \StructType\PaymentType
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentMethodType::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $method, implode(', ', \EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->Method = $method;
        return $this;
    }
    /**
     * Get Detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param string $detail
     * @return \StructType\PaymentType
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($detail) && strlen($detail) > 80) || (is_array($detail) && count($detail) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($detail) ? strlen($detail) : count($detail)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($detail) && strlen($detail) < 1) || (is_array($detail) && count($detail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detail)), __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
