<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteVaultRequestType StructType
 * @subpackage Structs
 */
class DeleteVaultRequestType extends AbstractStructBase
{
    /**
     * The VaultId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VaultId;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for DeleteVaultRequestType
     * @uses DeleteVaultRequestType::setVaultId()
     * @uses DeleteVaultRequestType::setAccount()
     * @uses DeleteVaultRequestType::setUserDefinedFields()
     * @param string $vaultId
     * @param \StructType\PayGateAccountType $account
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct($vaultId = null, \StructType\PayGateAccountType $account = null, array $userDefinedFields = array())
    {
        $this
            ->setVaultId($vaultId)
            ->setAccount($account)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get VaultId value
     * @return string
     */
    public function getVaultId()
    {
        return $this->VaultId;
    }
    /**
     * Set VaultId value
     * @param string $vaultId
     * @return \StructType\DeleteVaultRequestType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vaultId)), __LINE__);
        }
        $this->VaultId = $vaultId;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\DeleteVaultRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\DeleteVaultRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $deleteVaultRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$deleteVaultRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($deleteVaultRequestTypeUserDefinedFieldsItem) ? get_class($deleteVaultRequestTypeUserDefinedFieldsItem) : gettype($deleteVaultRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\DeleteVaultRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteVaultRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
