<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankPayoutRequestType StructType
 * @subpackage Structs
 */
class BankPayoutRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The AccountHolder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountHolder;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The BankCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BankCode;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountType;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BIC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BIC;
    /**
     * The IBAN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The PayoutType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayoutType;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for BankPayoutRequestType
     * @uses BankPayoutRequestType::setCustomer()
     * @uses BankPayoutRequestType::setAccountHolder()
     * @uses BankPayoutRequestType::setAccountNumber()
     * @uses BankPayoutRequestType::setBankCode()
     * @uses BankPayoutRequestType::setAccount()
     * @uses BankPayoutRequestType::setBankAccountType()
     * @uses BankPayoutRequestType::setBankName()
     * @uses BankPayoutRequestType::setBIC()
     * @uses BankPayoutRequestType::setIBAN()
     * @uses BankPayoutRequestType::setCountry()
     * @uses BankPayoutRequestType::setReference()
     * @uses BankPayoutRequestType::setPayoutType()
     * @uses BankPayoutRequestType::setOrder()
     * @uses BankPayoutRequestType::setUserDefinedFields()
     * @param \StructType\PersonType $customer
     * @param string $accountHolder
     * @param string $accountNumber
     * @param string $bankCode
     * @param \StructType\PayGateAccountType $account
     * @param string $bankAccountType
     * @param string $bankName
     * @param string $bIC
     * @param string $iBAN
     * @param string $country
     * @param string $reference
     * @param string $payoutType
     * @param \StructType\OrderType $order
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\PersonType $customer = null, $accountHolder = null, $accountNumber = null, $bankCode = null, \StructType\PayGateAccountType $account = null, $bankAccountType = null, $bankName = null, $bIC = null, $iBAN = null, $country = null, $reference = null, $payoutType = null, \StructType\OrderType $order = null, array $userDefinedFields = array())
    {
        $this
            ->setCustomer($customer)
            ->setAccountHolder($accountHolder)
            ->setAccountNumber($accountNumber)
            ->setBankCode($bankCode)
            ->setAccount($account)
            ->setBankAccountType($bankAccountType)
            ->setBankName($bankName)
            ->setBIC($bIC)
            ->setIBAN($iBAN)
            ->setCountry($country)
            ->setReference($reference)
            ->setPayoutType($payoutType)
            ->setOrder($order)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\BankPayoutRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get AccountHolder value
     * @return string
     */
    public function getAccountHolder()
    {
        return $this->AccountHolder;
    }
    /**
     * Set AccountHolder value
     * @param string $accountHolder
     * @return \StructType\BankPayoutRequestType
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountHolder)), __LINE__);
        }
        $this->AccountHolder = $accountHolder;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BankPayoutRequestType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get BankCode value
     * @return string
     */
    public function getBankCode()
    {
        return $this->BankCode;
    }
    /**
     * Set BankCode value
     * @param string $bankCode
     * @return \StructType\BankPayoutRequestType
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCode)), __LINE__);
        }
        $this->BankCode = $bankCode;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\BankPayoutRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string|null
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\BankPayoutRequestType
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\BankPayoutRequestType
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \StructType\BankPayoutRequestType
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bIC)), __LINE__);
        }
        $this->BIC = $bIC;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \StructType\BankPayoutRequestType
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\BankPayoutRequestType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $country, implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\BankPayoutRequestType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get PayoutType value
     * @return string|null
     */
    public function getPayoutType()
    {
        return $this->PayoutType;
    }
    /**
     * Set PayoutType value
     * @uses \EnumType\PayoutType::valueIsValid()
     * @uses \EnumType\PayoutType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payoutType
     * @return \StructType\BankPayoutRequestType
     */
    public function setPayoutType($payoutType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PayoutType::valueIsValid($payoutType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $payoutType, implode(', ', \EnumType\PayoutType::getValidValues())), __LINE__);
        }
        $this->PayoutType = $payoutType;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\BankPayoutRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\BankPayoutRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $bankPayoutRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$bankPayoutRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($bankPayoutRequestTypeUserDefinedFieldsItem) ? get_class($bankPayoutRequestTypeUserDefinedFieldsItem) : gettype($bankPayoutRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\BankPayoutRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankPayoutRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
