<?php

namespace EnumType;

/**
 * This class stands for BankAccountType EnumType
 * @subpackage Enumerations
 */
class BankAccountType
{
    /**
     * Constant for value 'Current'
     * @return string 'Current'
     */
    const VALUE_CURRENT = 'Current';
    /**
     * Constant for value 'Savings'
     * @return string 'Savings'
     */
    const VALUE_SAVINGS = 'Savings';
    /**
     * Constant for value 'Transmission'
     * @return string 'Transmission'
     */
    const VALUE_TRANSMISSION = 'Transmission';
    /**
     * Constant for value 'Bond'
     * @return string 'Bond'
     */
    const VALUE_BOND = 'Bond';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CURRENT
     * @uses self::VALUE_SAVINGS
     * @uses self::VALUE_TRANSMISSION
     * @uses self::VALUE_BOND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CURRENT,
            self::VALUE_SAVINGS,
            self::VALUE_TRANSMISSION,
            self::VALUE_BOND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
