<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebPaymentResponseType StructType
 * @subpackage Structs
 */
class WebPaymentResponseType extends AbstractStructBase
{
    /**
     * The Status
     * @var \StructType\StatusType
     */
    public $Status;
    /**
     * The Redirect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectResponseType
     */
    public $Redirect;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for WebPaymentResponseType
     * @uses WebPaymentResponseType::setStatus()
     * @uses WebPaymentResponseType::setRedirect()
     * @uses WebPaymentResponseType::setUserDefinedFields()
     * @param \StructType\StatusType $status
     * @param \StructType\RedirectResponseType $redirect
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\StatusType $status = null, \StructType\RedirectResponseType $redirect = null, array $userDefinedFields = array())
    {
        $this
            ->setStatus($status)
            ->setRedirect($redirect)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Status value
     * @return \StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\StatusType $status
     * @return \StructType\WebPaymentResponseType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectResponseType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectResponseType $redirect
     * @return \StructType\WebPaymentResponseType
     */
    public function setRedirect(\StructType\RedirectResponseType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\WebPaymentResponseType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $webPaymentResponseTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$webPaymentResponseTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($webPaymentResponseTypeUserDefinedFieldsItem) ? get_class($webPaymentResponseTypeUserDefinedFieldsItem) : gettype($webPaymentResponseTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\WebPaymentResponseType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebPaymentResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
