<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletPayoutRequestType StructType
 * @subpackage Structs
 */
class WalletPayoutRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The WalletType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WalletType;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The AccountHolder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolder;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for WalletPayoutRequestType
     * @uses WalletPayoutRequestType::setCustomer()
     * @uses WalletPayoutRequestType::setAccountNumber()
     * @uses WalletPayoutRequestType::setWalletType()
     * @uses WalletPayoutRequestType::setAccount()
     * @uses WalletPayoutRequestType::setAccountHolder()
     * @uses WalletPayoutRequestType::setCountry()
     * @uses WalletPayoutRequestType::setOrder()
     * @uses WalletPayoutRequestType::setUserDefinedFields()
     * @param \StructType\PersonType $customer
     * @param string $accountNumber
     * @param string $walletType
     * @param \StructType\PayGateAccountType $account
     * @param string $accountHolder
     * @param string $country
     * @param \StructType\OrderType $order
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\PersonType $customer = null, $accountNumber = null, $walletType = null, \StructType\PayGateAccountType $account = null, $accountHolder = null, $country = null, \StructType\OrderType $order = null, array $userDefinedFields = array())
    {
        $this
            ->setCustomer($customer)
            ->setAccountNumber($accountNumber)
            ->setWalletType($walletType)
            ->setAccount($account)
            ->setAccountHolder($accountHolder)
            ->setCountry($country)
            ->setOrder($order)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\WalletPayoutRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\WalletPayoutRequestType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get WalletType value
     * @return string
     */
    public function getWalletType()
    {
        return $this->WalletType;
    }
    /**
     * Set WalletType value
     * @param string $walletType
     * @return \StructType\WalletPayoutRequestType
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: string
        if (!is_null($walletType) && !is_string($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletType)), __LINE__);
        }
        $this->WalletType = $walletType;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\WalletPayoutRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountHolder value
     * @return string|null
     */
    public function getAccountHolder()
    {
        return $this->AccountHolder;
    }
    /**
     * Set AccountHolder value
     * @param string $accountHolder
     * @return \StructType\WalletPayoutRequestType
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountHolder)), __LINE__);
        }
        $this->AccountHolder = $accountHolder;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\WalletPayoutRequestType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $country, implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\WalletPayoutRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\WalletPayoutRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $walletPayoutRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$walletPayoutRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($walletPayoutRequestTypeUserDefinedFieldsItem) ? get_class($walletPayoutRequestTypeUserDefinedFieldsItem) : gettype($walletPayoutRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\WalletPayoutRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WalletPayoutRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
