<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePaymentRequest StructType
 * @subpackage Structs
 */
class SinglePaymentRequest extends AbstractStructBase
{
    /**
     * The CardPaymentRequest
     * @var \StructType\CardPaymentRequestType
     */
    public $CardPaymentRequest;
    /**
     * The WebPaymentRequest
     * @var \StructType\WebPaymentRequestType
     */
    public $WebPaymentRequest;
    /**
     * The TokenPaymentRequest
     * @var \StructType\TokenPaymentRequestType
     */
    public $TokenPaymentRequest;
    /**
     * The BankPaymentRequest
     * @var \StructType\BankPaymentRequestType
     */
    public $BankPaymentRequest;
    /**
     * Constructor method for SinglePaymentRequest
     * @uses SinglePaymentRequest::setCardPaymentRequest()
     * @uses SinglePaymentRequest::setWebPaymentRequest()
     * @uses SinglePaymentRequest::setTokenPaymentRequest()
     * @uses SinglePaymentRequest::setBankPaymentRequest()
     * @param \StructType\CardPaymentRequestType $cardPaymentRequest
     * @param \StructType\WebPaymentRequestType $webPaymentRequest
     * @param \StructType\TokenPaymentRequestType $tokenPaymentRequest
     * @param \StructType\BankPaymentRequestType $bankPaymentRequest
     */
    public function __construct(\StructType\CardPaymentRequestType $cardPaymentRequest = null, \StructType\WebPaymentRequestType $webPaymentRequest = null, \StructType\TokenPaymentRequestType $tokenPaymentRequest = null, \StructType\BankPaymentRequestType $bankPaymentRequest = null)
    {
        $this
            ->setCardPaymentRequest($cardPaymentRequest)
            ->setWebPaymentRequest($webPaymentRequest)
            ->setTokenPaymentRequest($tokenPaymentRequest)
            ->setBankPaymentRequest($bankPaymentRequest);
    }
    /**
     * Get CardPaymentRequest value
     * @return \StructType\CardPaymentRequestType|null
     */
    public function getCardPaymentRequest()
    {
        return $this->CardPaymentRequest;
    }
    /**
     * Set CardPaymentRequest value
     * @param \StructType\CardPaymentRequestType $cardPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setCardPaymentRequest(\StructType\CardPaymentRequestType $cardPaymentRequest = null)
    {
        $this->CardPaymentRequest = $cardPaymentRequest;
        return $this;
    }
    /**
     * Get WebPaymentRequest value
     * @return \StructType\WebPaymentRequestType|null
     */
    public function getWebPaymentRequest()
    {
        return $this->WebPaymentRequest;
    }
    /**
     * Set WebPaymentRequest value
     * @param \StructType\WebPaymentRequestType $webPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setWebPaymentRequest(\StructType\WebPaymentRequestType $webPaymentRequest = null)
    {
        $this->WebPaymentRequest = $webPaymentRequest;
        return $this;
    }
    /**
     * Get TokenPaymentRequest value
     * @return \StructType\TokenPaymentRequestType|null
     */
    public function getTokenPaymentRequest()
    {
        return $this->TokenPaymentRequest;
    }
    /**
     * Set TokenPaymentRequest value
     * @param \StructType\TokenPaymentRequestType $tokenPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setTokenPaymentRequest(\StructType\TokenPaymentRequestType $tokenPaymentRequest = null)
    {
        $this->TokenPaymentRequest = $tokenPaymentRequest;
        return $this;
    }
    /**
     * Get BankPaymentRequest value
     * @return \StructType\BankPaymentRequestType|null
     */
    public function getBankPaymentRequest()
    {
        return $this->BankPaymentRequest;
    }
    /**
     * Set BankPaymentRequest value
     * @param \StructType\BankPaymentRequestType $bankPaymentRequest
     * @return \StructType\SinglePaymentRequest
     */
    public function setBankPaymentRequest(\StructType\BankPaymentRequestType $bankPaymentRequest = null)
    {
        $this->BankPaymentRequest = $bankPaymentRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SinglePaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
