<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleFollowUpResponse StructType
 * @subpackage Structs
 */
class SingleFollowUpResponse extends AbstractStructBase
{
    /**
     * The QueryResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\QueryResponseType[]
     */
    public $QueryResponse;
    /**
     * The SettlementResponse
     * @var \StructType\SettleResponseType
     */
    public $SettlementResponse;
    /**
     * The RefundResponse
     * @var \StructType\RefundResponseType
     */
    public $RefundResponse;
    /**
     * The VoidResponse
     * @var \StructType\VoidResponseType
     */
    public $VoidResponse;
    /**
     * Constructor method for SingleFollowUpResponse
     * @uses SingleFollowUpResponse::setQueryResponse()
     * @uses SingleFollowUpResponse::setSettlementResponse()
     * @uses SingleFollowUpResponse::setRefundResponse()
     * @uses SingleFollowUpResponse::setVoidResponse()
     * @param \StructType\QueryResponseType[] $queryResponse
     * @param \StructType\SettleResponseType $settlementResponse
     * @param \StructType\RefundResponseType $refundResponse
     * @param \StructType\VoidResponseType $voidResponse
     */
    public function __construct(array $queryResponse = array(), \StructType\SettleResponseType $settlementResponse = null, \StructType\RefundResponseType $refundResponse = null, \StructType\VoidResponseType $voidResponse = null)
    {
        $this
            ->setQueryResponse($queryResponse)
            ->setSettlementResponse($settlementResponse)
            ->setRefundResponse($refundResponse)
            ->setVoidResponse($voidResponse);
    }
    /**
     * Get QueryResponse value
     * @return \StructType\QueryResponseType[]
     */
    public function getQueryResponse()
    {
        return $this->QueryResponse;
    }
    /**
     * Set QueryResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryResponseType[] $queryResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setQueryResponse(array $queryResponse = array())
    {
        foreach ($queryResponse as $singleFollowUpResponseQueryResponseItem) {
            // validation for constraint: itemType
            if (!$singleFollowUpResponseQueryResponseItem instanceof \StructType\QueryResponseType) {
                throw new \InvalidArgumentException(sprintf('The QueryResponse property can only contain items of \StructType\QueryResponseType, "%s" given', is_object($singleFollowUpResponseQueryResponseItem) ? get_class($singleFollowUpResponseQueryResponseItem) : gettype($singleFollowUpResponseQueryResponseItem)), __LINE__);
            }
        }
        $this->QueryResponse = $queryResponse;
        return $this;
    }
    /**
     * Add item to QueryResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryResponseType $item
     * @return \StructType\SingleFollowUpResponse
     */
    public function addToQueryResponse(\StructType\QueryResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QueryResponseType) {
            throw new \InvalidArgumentException(sprintf('The QueryResponse property can only contain items of \StructType\QueryResponseType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QueryResponse[] = $item;
        return $this;
    }
    /**
     * Get SettlementResponse value
     * @return \StructType\SettleResponseType|null
     */
    public function getSettlementResponse()
    {
        return $this->SettlementResponse;
    }
    /**
     * Set SettlementResponse value
     * @param \StructType\SettleResponseType $settlementResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setSettlementResponse(\StructType\SettleResponseType $settlementResponse = null)
    {
        $this->SettlementResponse = $settlementResponse;
        return $this;
    }
    /**
     * Get RefundResponse value
     * @return \StructType\RefundResponseType|null
     */
    public function getRefundResponse()
    {
        return $this->RefundResponse;
    }
    /**
     * Set RefundResponse value
     * @param \StructType\RefundResponseType $refundResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setRefundResponse(\StructType\RefundResponseType $refundResponse = null)
    {
        $this->RefundResponse = $refundResponse;
        return $this;
    }
    /**
     * Get VoidResponse value
     * @return \StructType\VoidResponseType|null
     */
    public function getVoidResponse()
    {
        return $this->VoidResponse;
    }
    /**
     * Set VoidResponse value
     * @param \StructType\VoidResponseType $voidResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setVoidResponse(\StructType\VoidResponseType $voidResponse = null)
    {
        $this->VoidResponse = $voidResponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SingleFollowUpResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
