<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PingRequest StructType
 * @subpackage Structs
 */
class PingRequest extends AbstractStructBase
{
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The Identifier
     * @var string
     */
    public $Identifier;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for PingRequest
     * @uses PingRequest::setAccount()
     * @uses PingRequest::setIdentifier()
     * @uses PingRequest::setUserDefinedFields()
     * @param \StructType\PayGateAccountType $account
     * @param string $identifier
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\PayGateAccountType $account = null, $identifier = null, array $userDefinedFields = array())
    {
        $this
            ->setAccount($account)
            ->setIdentifier($identifier)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\PingRequest
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \StructType\PingRequest
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\PingRequest
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $pingRequestUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$pingRequestUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($pingRequestUserDefinedFieldsItem) ? get_class($pingRequestUserDefinedFieldsItem) : gettype($pingRequestUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\PingRequest
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
