<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderType StructType
 * @subpackage Structs
 */
class OrderType extends AbstractStructBase
{
    /**
     * The MerchantOrderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantOrderId;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Amount;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Discount;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionDate;
    /**
     * The BillingDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingDetailsType
     */
    public $BillingDetails;
    /**
     * The ShippingDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShippingDetailsType
     */
    public $ShippingDetails;
    /**
     * The AirlineBookingDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AirlineBookingDetailsType
     */
    public $AirlineBookingDetails;
    /**
     * The OrderItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderItemType[]
     */
    public $OrderItems;
    /**
     * The Locale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*
     * @var string
     */
    public $Locale;
    /**
     * Constructor method for OrderType
     * @uses OrderType::setMerchantOrderId()
     * @uses OrderType::setCurrency()
     * @uses OrderType::setAmount()
     * @uses OrderType::setDiscount()
     * @uses OrderType::setTransactionDate()
     * @uses OrderType::setBillingDetails()
     * @uses OrderType::setShippingDetails()
     * @uses OrderType::setAirlineBookingDetails()
     * @uses OrderType::setOrderItems()
     * @uses OrderType::setLocale()
     * @param string $merchantOrderId
     * @param string $currency
     * @param int $amount
     * @param int $discount
     * @param string $transactionDate
     * @param \StructType\BillingDetailsType $billingDetails
     * @param \StructType\ShippingDetailsType $shippingDetails
     * @param \StructType\AirlineBookingDetailsType $airlineBookingDetails
     * @param \StructType\OrderItemType[] $orderItems
     * @param string $locale
     */
    public function __construct($merchantOrderId = null, $currency = null, $amount = null, $discount = null, $transactionDate = null, \StructType\BillingDetailsType $billingDetails = null, \StructType\ShippingDetailsType $shippingDetails = null, \StructType\AirlineBookingDetailsType $airlineBookingDetails = null, array $orderItems = array(), $locale = null)
    {
        $this
            ->setMerchantOrderId($merchantOrderId)
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setDiscount($discount)
            ->setTransactionDate($transactionDate)
            ->setBillingDetails($billingDetails)
            ->setShippingDetails($shippingDetails)
            ->setAirlineBookingDetails($airlineBookingDetails)
            ->setOrderItems($orderItems)
            ->setLocale($locale);
    }
    /**
     * Get MerchantOrderId value
     * @return string
     */
    public function getMerchantOrderId()
    {
        return $this->MerchantOrderId;
    }
    /**
     * Set MerchantOrderId value
     * @param string $merchantOrderId
     * @return \StructType\OrderType
     */
    public function setMerchantOrderId($merchantOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantOrderId) && !is_string($merchantOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantOrderId)), __LINE__);
        }
        $this->MerchantOrderId = $merchantOrderId;
        return $this;
    }
    /**
     * Get Currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\OrderType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currency, implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\OrderType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Discount value
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param int $discount
     * @return \StructType\OrderType
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: int
        if (!is_null($discount) && !is_numeric($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\OrderType
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get BillingDetails value
     * @return \StructType\BillingDetailsType|null
     */
    public function getBillingDetails()
    {
        return $this->BillingDetails;
    }
    /**
     * Set BillingDetails value
     * @param \StructType\BillingDetailsType $billingDetails
     * @return \StructType\OrderType
     */
    public function setBillingDetails(\StructType\BillingDetailsType $billingDetails = null)
    {
        $this->BillingDetails = $billingDetails;
        return $this;
    }
    /**
     * Get ShippingDetails value
     * @return \StructType\ShippingDetailsType|null
     */
    public function getShippingDetails()
    {
        return $this->ShippingDetails;
    }
    /**
     * Set ShippingDetails value
     * @param \StructType\ShippingDetailsType $shippingDetails
     * @return \StructType\OrderType
     */
    public function setShippingDetails(\StructType\ShippingDetailsType $shippingDetails = null)
    {
        $this->ShippingDetails = $shippingDetails;
        return $this;
    }
    /**
     * Get AirlineBookingDetails value
     * @return \StructType\AirlineBookingDetailsType|null
     */
    public function getAirlineBookingDetails()
    {
        return $this->AirlineBookingDetails;
    }
    /**
     * Set AirlineBookingDetails value
     * @param \StructType\AirlineBookingDetailsType $airlineBookingDetails
     * @return \StructType\OrderType
     */
    public function setAirlineBookingDetails(\StructType\AirlineBookingDetailsType $airlineBookingDetails = null)
    {
        $this->AirlineBookingDetails = $airlineBookingDetails;
        return $this;
    }
    /**
     * Get OrderItems value
     * @return \StructType\OrderItemType[]|null
     */
    public function getOrderItems()
    {
        return $this->OrderItems;
    }
    /**
     * Set OrderItems value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemType[] $orderItems
     * @return \StructType\OrderType
     */
    public function setOrderItems(array $orderItems = array())
    {
        foreach ($orderItems as $orderTypeOrderItemsItem) {
            // validation for constraint: itemType
            if (!$orderTypeOrderItemsItem instanceof \StructType\OrderItemType) {
                throw new \InvalidArgumentException(sprintf('The OrderItems property can only contain items of \StructType\OrderItemType, "%s" given', is_object($orderTypeOrderItemsItem) ? get_class($orderTypeOrderItemsItem) : gettype($orderTypeOrderItemsItem)), __LINE__);
            }
        }
        $this->OrderItems = $orderItems;
        return $this;
    }
    /**
     * Add item to OrderItems value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemType $item
     * @return \StructType\OrderType
     */
    public function addToOrderItems(\StructType\OrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemType) {
            throw new \InvalidArgumentException(sprintf('The OrderItems property can only contain items of \StructType\OrderItemType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderItems[] = $item;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \StructType\OrderType
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: pattern
        if (is_scalar($locale) && !preg_match('/([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*/', $locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*", "%s" given', var_export($locale, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
