<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineBookingDetailsType StructType
 * @subpackage Structs
 */
class AirlineBookingDetailsType extends AbstractStructBase
{
    /**
     * The PNR
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PNR;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * The InternalCustomerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalCustomerCode;
    /**
     * The ReservationSystem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationSystem;
    /**
     * The TravelAgencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TravelAgencyCode;
    /**
     * The TravelAgencyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TravelAgencyName;
    /**
     * The PayerTravelling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PayerTravelling;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PassengerType[]
     */
    public $Passengers;
    /**
     * The FlightLegs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FlightLegType[]
     */
    public $FlightLegs;
    /**
     * Constructor method for AirlineBookingDetailsType
     * @uses AirlineBookingDetailsType::setPNR()
     * @uses AirlineBookingDetailsType::setTicketNumber()
     * @uses AirlineBookingDetailsType::setInternalCustomerCode()
     * @uses AirlineBookingDetailsType::setReservationSystem()
     * @uses AirlineBookingDetailsType::setTravelAgencyCode()
     * @uses AirlineBookingDetailsType::setTravelAgencyName()
     * @uses AirlineBookingDetailsType::setPayerTravelling()
     * @uses AirlineBookingDetailsType::setPassengers()
     * @uses AirlineBookingDetailsType::setFlightLegs()
     * @param string $pNR
     * @param string $ticketNumber
     * @param string $internalCustomerCode
     * @param string $reservationSystem
     * @param string $travelAgencyCode
     * @param string $travelAgencyName
     * @param bool $payerTravelling
     * @param \StructType\PassengerType[] $passengers
     * @param \StructType\FlightLegType[] $flightLegs
     */
    public function __construct($pNR = null, $ticketNumber = null, $internalCustomerCode = null, $reservationSystem = null, $travelAgencyCode = null, $travelAgencyName = null, $payerTravelling = null, array $passengers = array(), array $flightLegs = array())
    {
        $this
            ->setPNR($pNR)
            ->setTicketNumber($ticketNumber)
            ->setInternalCustomerCode($internalCustomerCode)
            ->setReservationSystem($reservationSystem)
            ->setTravelAgencyCode($travelAgencyCode)
            ->setTravelAgencyName($travelAgencyName)
            ->setPayerTravelling($payerTravelling)
            ->setPassengers($passengers)
            ->setFlightLegs($flightLegs);
    }
    /**
     * Get PNR value
     * @return string
     */
    public function getPNR()
    {
        return $this->PNR;
    }
    /**
     * Set PNR value
     * @param string $pNR
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setPNR($pNR = null)
    {
        // validation for constraint: string
        if (!is_null($pNR) && !is_string($pNR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNR)), __LINE__);
        }
        $this->PNR = $pNR;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get InternalCustomerCode value
     * @return string|null
     */
    public function getInternalCustomerCode()
    {
        return $this->InternalCustomerCode;
    }
    /**
     * Set InternalCustomerCode value
     * @param string $internalCustomerCode
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setInternalCustomerCode($internalCustomerCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalCustomerCode) && !is_string($internalCustomerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalCustomerCode)), __LINE__);
        }
        $this->InternalCustomerCode = $internalCustomerCode;
        return $this;
    }
    /**
     * Get ReservationSystem value
     * @return string|null
     */
    public function getReservationSystem()
    {
        return $this->ReservationSystem;
    }
    /**
     * Set ReservationSystem value
     * @param string $reservationSystem
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setReservationSystem($reservationSystem = null)
    {
        // validation for constraint: string
        if (!is_null($reservationSystem) && !is_string($reservationSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationSystem)), __LINE__);
        }
        $this->ReservationSystem = $reservationSystem;
        return $this;
    }
    /**
     * Get TravelAgencyCode value
     * @return string|null
     */
    public function getTravelAgencyCode()
    {
        return $this->TravelAgencyCode;
    }
    /**
     * Set TravelAgencyCode value
     * @param string $travelAgencyCode
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setTravelAgencyCode($travelAgencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyCode) && !is_string($travelAgencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelAgencyCode)), __LINE__);
        }
        $this->TravelAgencyCode = $travelAgencyCode;
        return $this;
    }
    /**
     * Get TravelAgencyName value
     * @return string|null
     */
    public function getTravelAgencyName()
    {
        return $this->TravelAgencyName;
    }
    /**
     * Set TravelAgencyName value
     * @param string $travelAgencyName
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setTravelAgencyName($travelAgencyName = null)
    {
        // validation for constraint: string
        if (!is_null($travelAgencyName) && !is_string($travelAgencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelAgencyName)), __LINE__);
        }
        $this->TravelAgencyName = $travelAgencyName;
        return $this;
    }
    /**
     * Get PayerTravelling value
     * @return bool|null
     */
    public function getPayerTravelling()
    {
        return $this->PayerTravelling;
    }
    /**
     * Set PayerTravelling value
     * @param bool $payerTravelling
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setPayerTravelling($payerTravelling = null)
    {
        // validation for constraint: boolean
        if (!is_null($payerTravelling) && !is_bool($payerTravelling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($payerTravelling)), __LINE__);
        }
        $this->PayerTravelling = $payerTravelling;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \StructType\PassengerType[]|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerType[] $passengers
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setPassengers(array $passengers = array())
    {
        foreach ($passengers as $airlineBookingDetailsTypePassengersItem) {
            // validation for constraint: itemType
            if (!$airlineBookingDetailsTypePassengersItem instanceof \StructType\PassengerType) {
                throw new \InvalidArgumentException(sprintf('The Passengers property can only contain items of \StructType\PassengerType, "%s" given', is_object($airlineBookingDetailsTypePassengersItem) ? get_class($airlineBookingDetailsTypePassengersItem) : gettype($airlineBookingDetailsTypePassengersItem)), __LINE__);
            }
        }
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Add item to Passengers value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerType $item
     * @return \StructType\AirlineBookingDetailsType
     */
    public function addToPassengers(\StructType\PassengerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerType) {
            throw new \InvalidArgumentException(sprintf('The Passengers property can only contain items of \StructType\PassengerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Passengers[] = $item;
        return $this;
    }
    /**
     * Get FlightLegs value
     * @return \StructType\FlightLegType[]|null
     */
    public function getFlightLegs()
    {
        return $this->FlightLegs;
    }
    /**
     * Set FlightLegs value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLegType[] $flightLegs
     * @return \StructType\AirlineBookingDetailsType
     */
    public function setFlightLegs(array $flightLegs = array())
    {
        foreach ($flightLegs as $airlineBookingDetailsTypeFlightLegsItem) {
            // validation for constraint: itemType
            if (!$airlineBookingDetailsTypeFlightLegsItem instanceof \StructType\FlightLegType) {
                throw new \InvalidArgumentException(sprintf('The FlightLegs property can only contain items of \StructType\FlightLegType, "%s" given', is_object($airlineBookingDetailsTypeFlightLegsItem) ? get_class($airlineBookingDetailsTypeFlightLegsItem) : gettype($airlineBookingDetailsTypeFlightLegsItem)), __LINE__);
            }
        }
        $this->FlightLegs = $flightLegs;
        return $this;
    }
    /**
     * Add item to FlightLegs value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLegType $item
     * @return \StructType\AirlineBookingDetailsType
     */
    public function addToFlightLegs(\StructType\FlightLegType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightLegType) {
            throw new \InvalidArgumentException(sprintf('The FlightLegs property can only contain items of \StructType\FlightLegType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightLegs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirlineBookingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
