<?php

namespace EnumType;

/**
 * This class stands for TransactionCodeType EnumType
 * @subpackage Enumerations
 */
class TransactionCodeType
{
    /**
     * Constant for value 'NotDone'
     * @return string 'NotDone'
     */
    const VALUE_NOT_DONE = 'NotDone';
    /**
     * Constant for value 'Approved'
     * @return string 'Approved'
     */
    const VALUE_APPROVED = 'Approved';
    /**
     * Constant for value 'Declined'
     * @return string 'Declined'
     */
    const VALUE_DECLINED = 'Declined';
    /**
     * Constant for value 'Paid'
     * @return string 'Paid'
     */
    const VALUE_PAID = 'Paid';
    /**
     * Constant for value 'Refunded'
     * @return string 'Refunded'
     */
    const VALUE_REFUNDED = 'Refunded';
    /**
     * Constant for value 'ReceivedByPaygate'
     * @return string 'ReceivedByPaygate'
     */
    const VALUE_RECEIVED_BY_PAYGATE = 'ReceivedByPaygate';
    /**
     * Constant for value 'RepliedToClient'
     * @return string 'RepliedToClient'
     */
    const VALUE_REPLIED_TO_CLIENT = 'RepliedToClient';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_DONE
     * @uses self::VALUE_APPROVED
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_PAID
     * @uses self::VALUE_REFUNDED
     * @uses self::VALUE_RECEIVED_BY_PAYGATE
     * @uses self::VALUE_REPLIED_TO_CLIENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_DONE,
            self::VALUE_APPROVED,
            self::VALUE_DECLINED,
            self::VALUE_PAID,
            self::VALUE_REFUNDED,
            self::VALUE_RECEIVED_BY_PAYGATE,
            self::VALUE_REPLIED_TO_CLIENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
