<?php

namespace EnumType;

/**
 * This class stands for PayoutType EnumType
 * @subpackage Enumerations
 */
class PayoutType
{
    /**
     * Constant for value 'Eft'
     * @return string 'Eft'
     */
    const VALUE_EFT = 'Eft';
    /**
     * Constant for value 'Salary'
     * @return string 'Salary'
     */
    const VALUE_SALARY = 'Salary';
    /**
     * Constant for value 'PayAndClear'
     * @return string 'PayAndClear'
     */
    const VALUE_PAY_AND_CLEAR = 'PayAndClear';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EFT
     * @uses self::VALUE_SALARY
     * @uses self::VALUE_PAY_AND_CLEAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EFT,
            self::VALUE_SALARY,
            self::VALUE_PAY_AND_CLEAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
