<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePayoutResponse StructType
 * @subpackage Structs
 */
class SinglePayoutResponse extends AbstractStructBase
{
    /**
     * The CardPayoutResponse
     * @var \StructType\CardPayoutResponseType
     */
    public $CardPayoutResponse;
    /**
     * The BankPayoutResponse
     * @var \StructType\BankPayoutResponseType
     */
    public $BankPayoutResponse;
    /**
     * The WalletPayoutResponse
     * @var \StructType\WalletPayoutResponseType
     */
    public $WalletPayoutResponse;
    /**
     * Constructor method for SinglePayoutResponse
     * @uses SinglePayoutResponse::setCardPayoutResponse()
     * @uses SinglePayoutResponse::setBankPayoutResponse()
     * @uses SinglePayoutResponse::setWalletPayoutResponse()
     * @param \StructType\CardPayoutResponseType $cardPayoutResponse
     * @param \StructType\BankPayoutResponseType $bankPayoutResponse
     * @param \StructType\WalletPayoutResponseType $walletPayoutResponse
     */
    public function __construct(\StructType\CardPayoutResponseType $cardPayoutResponse = null, \StructType\BankPayoutResponseType $bankPayoutResponse = null, \StructType\WalletPayoutResponseType $walletPayoutResponse = null)
    {
        $this
            ->setCardPayoutResponse($cardPayoutResponse)
            ->setBankPayoutResponse($bankPayoutResponse)
            ->setWalletPayoutResponse($walletPayoutResponse);
    }
    /**
     * Get CardPayoutResponse value
     * @return \StructType\CardPayoutResponseType|null
     */
    public function getCardPayoutResponse()
    {
        return $this->CardPayoutResponse;
    }
    /**
     * Set CardPayoutResponse value
     * @param \StructType\CardPayoutResponseType $cardPayoutResponse
     * @return \StructType\SinglePayoutResponse
     */
    public function setCardPayoutResponse(\StructType\CardPayoutResponseType $cardPayoutResponse = null)
    {
        $this->CardPayoutResponse = $cardPayoutResponse;
        return $this;
    }
    /**
     * Get BankPayoutResponse value
     * @return \StructType\BankPayoutResponseType|null
     */
    public function getBankPayoutResponse()
    {
        return $this->BankPayoutResponse;
    }
    /**
     * Set BankPayoutResponse value
     * @param \StructType\BankPayoutResponseType $bankPayoutResponse
     * @return \StructType\SinglePayoutResponse
     */
    public function setBankPayoutResponse(\StructType\BankPayoutResponseType $bankPayoutResponse = null)
    {
        $this->BankPayoutResponse = $bankPayoutResponse;
        return $this;
    }
    /**
     * Get WalletPayoutResponse value
     * @return \StructType\WalletPayoutResponseType|null
     */
    public function getWalletPayoutResponse()
    {
        return $this->WalletPayoutResponse;
    }
    /**
     * Set WalletPayoutResponse value
     * @param \StructType\WalletPayoutResponseType $walletPayoutResponse
     * @return \StructType\SinglePayoutResponse
     */
    public function setWalletPayoutResponse(\StructType\WalletPayoutResponseType $walletPayoutResponse = null)
    {
        $this->WalletPayoutResponse = $walletPayoutResponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SinglePayoutResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
