<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePayoutRequest StructType
 * @subpackage Structs
 */
class SinglePayoutRequest extends AbstractStructBase
{
    /**
     * The CardPayoutRequest
     * @var \StructType\CardPayoutRequestType
     */
    public $CardPayoutRequest;
    /**
     * The BankPayoutRequest
     * @var \StructType\BankPayoutRequestType
     */
    public $BankPayoutRequest;
    /**
     * The WalletPayoutRequest
     * @var \StructType\WalletPayoutRequestType
     */
    public $WalletPayoutRequest;
    /**
     * Constructor method for SinglePayoutRequest
     * @uses SinglePayoutRequest::setCardPayoutRequest()
     * @uses SinglePayoutRequest::setBankPayoutRequest()
     * @uses SinglePayoutRequest::setWalletPayoutRequest()
     * @param \StructType\CardPayoutRequestType $cardPayoutRequest
     * @param \StructType\BankPayoutRequestType $bankPayoutRequest
     * @param \StructType\WalletPayoutRequestType $walletPayoutRequest
     */
    public function __construct(\StructType\CardPayoutRequestType $cardPayoutRequest = null, \StructType\BankPayoutRequestType $bankPayoutRequest = null, \StructType\WalletPayoutRequestType $walletPayoutRequest = null)
    {
        $this
            ->setCardPayoutRequest($cardPayoutRequest)
            ->setBankPayoutRequest($bankPayoutRequest)
            ->setWalletPayoutRequest($walletPayoutRequest);
    }
    /**
     * Get CardPayoutRequest value
     * @return \StructType\CardPayoutRequestType|null
     */
    public function getCardPayoutRequest()
    {
        return $this->CardPayoutRequest;
    }
    /**
     * Set CardPayoutRequest value
     * @param \StructType\CardPayoutRequestType $cardPayoutRequest
     * @return \StructType\SinglePayoutRequest
     */
    public function setCardPayoutRequest(\StructType\CardPayoutRequestType $cardPayoutRequest = null)
    {
        $this->CardPayoutRequest = $cardPayoutRequest;
        return $this;
    }
    /**
     * Get BankPayoutRequest value
     * @return \StructType\BankPayoutRequestType|null
     */
    public function getBankPayoutRequest()
    {
        return $this->BankPayoutRequest;
    }
    /**
     * Set BankPayoutRequest value
     * @param \StructType\BankPayoutRequestType $bankPayoutRequest
     * @return \StructType\SinglePayoutRequest
     */
    public function setBankPayoutRequest(\StructType\BankPayoutRequestType $bankPayoutRequest = null)
    {
        $this->BankPayoutRequest = $bankPayoutRequest;
        return $this;
    }
    /**
     * Get WalletPayoutRequest value
     * @return \StructType\WalletPayoutRequestType|null
     */
    public function getWalletPayoutRequest()
    {
        return $this->WalletPayoutRequest;
    }
    /**
     * Set WalletPayoutRequest value
     * @param \StructType\WalletPayoutRequestType $walletPayoutRequest
     * @return \StructType\SinglePayoutRequest
     */
    public function setWalletPayoutRequest(\StructType\WalletPayoutRequestType $walletPayoutRequest = null)
    {
        $this->WalletPayoutRequest = $walletPayoutRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SinglePayoutRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
