<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleFollowUpRequest StructType
 * @subpackage Structs
 */
class SingleFollowUpRequest extends AbstractStructBase
{
    /**
     * The QueryRequest
     * @var \StructType\QueryRequestType
     */
    public $QueryRequest;
    /**
     * The SettlementRequest
     * @var \StructType\SettleRequestType
     */
    public $SettlementRequest;
    /**
     * The RefundRequest
     * @var \StructType\RefundRequestType
     */
    public $RefundRequest;
    /**
     * The VoidRequest
     * @var \StructType\VoidRequestType
     */
    public $VoidRequest;
    /**
     * Constructor method for SingleFollowUpRequest
     * @uses SingleFollowUpRequest::setQueryRequest()
     * @uses SingleFollowUpRequest::setSettlementRequest()
     * @uses SingleFollowUpRequest::setRefundRequest()
     * @uses SingleFollowUpRequest::setVoidRequest()
     * @param \StructType\QueryRequestType $queryRequest
     * @param \StructType\SettleRequestType $settlementRequest
     * @param \StructType\RefundRequestType $refundRequest
     * @param \StructType\VoidRequestType $voidRequest
     */
    public function __construct(\StructType\QueryRequestType $queryRequest = null, \StructType\SettleRequestType $settlementRequest = null, \StructType\RefundRequestType $refundRequest = null, \StructType\VoidRequestType $voidRequest = null)
    {
        $this
            ->setQueryRequest($queryRequest)
            ->setSettlementRequest($settlementRequest)
            ->setRefundRequest($refundRequest)
            ->setVoidRequest($voidRequest);
    }
    /**
     * Get QueryRequest value
     * @return \StructType\QueryRequestType|null
     */
    public function getQueryRequest()
    {
        return $this->QueryRequest;
    }
    /**
     * Set QueryRequest value
     * @param \StructType\QueryRequestType $queryRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setQueryRequest(\StructType\QueryRequestType $queryRequest = null)
    {
        $this->QueryRequest = $queryRequest;
        return $this;
    }
    /**
     * Get SettlementRequest value
     * @return \StructType\SettleRequestType|null
     */
    public function getSettlementRequest()
    {
        return $this->SettlementRequest;
    }
    /**
     * Set SettlementRequest value
     * @param \StructType\SettleRequestType $settlementRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setSettlementRequest(\StructType\SettleRequestType $settlementRequest = null)
    {
        $this->SettlementRequest = $settlementRequest;
        return $this;
    }
    /**
     * Get RefundRequest value
     * @return \StructType\RefundRequestType|null
     */
    public function getRefundRequest()
    {
        return $this->RefundRequest;
    }
    /**
     * Set RefundRequest value
     * @param \StructType\RefundRequestType $refundRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setRefundRequest(\StructType\RefundRequestType $refundRequest = null)
    {
        $this->RefundRequest = $refundRequest;
        return $this;
    }
    /**
     * Get VoidRequest value
     * @return \StructType\VoidRequestType|null
     */
    public function getVoidRequest()
    {
        return $this->VoidRequest;
    }
    /**
     * Set VoidRequest value
     * @param \StructType\VoidRequestType $voidRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setVoidRequest(\StructType\VoidRequestType $voidRequest = null)
    {
        $this->VoidRequest = $voidRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SingleFollowUpRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
