<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettleRequestType StructType
 * @subpackage Structs
 */
class SettleRequestType extends AbstractStructBase
{
    /**
     * The TransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionId;
    /**
     * The MerchantOrderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantOrderId;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for SettleRequestType
     * @uses SettleRequestType::setTransactionId()
     * @uses SettleRequestType::setMerchantOrderId()
     * @uses SettleRequestType::setAccount()
     * @uses SettleRequestType::setUserDefinedFields()
     * @param string $transactionId
     * @param string $merchantOrderId
     * @param \StructType\PayGateAccountType $account
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct($transactionId = null, $merchantOrderId = null, \StructType\PayGateAccountType $account = null, array $userDefinedFields = array())
    {
        $this
            ->setTransactionId($transactionId)
            ->setMerchantOrderId($merchantOrderId)
            ->setAccount($account)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get TransactionId value
     * @return string
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\SettleRequestType
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get MerchantOrderId value
     * @return string
     */
    public function getMerchantOrderId()
    {
        return $this->MerchantOrderId;
    }
    /**
     * Set MerchantOrderId value
     * @param string $merchantOrderId
     * @return \StructType\SettleRequestType
     */
    public function setMerchantOrderId($merchantOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantOrderId) && !is_string($merchantOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantOrderId)), __LINE__);
        }
        $this->MerchantOrderId = $merchantOrderId;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\SettleRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\SettleRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $settleRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$settleRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($settleRequestTypeUserDefinedFieldsItem) ? get_class($settleRequestTypeUserDefinedFieldsItem) : gettype($settleRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\SettleRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SettleRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
