<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundRequestType StructType
 * @subpackage Structs
 */
class RefundRequestType extends AbstractStructBase
{
    /**
     * The TransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionId;
    /**
     * The MerchantOrderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantOrderId;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Amount;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The UserDefinedFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for RefundRequestType
     * @uses RefundRequestType::setTransactionId()
     * @uses RefundRequestType::setMerchantOrderId()
     * @uses RefundRequestType::setAmount()
     * @uses RefundRequestType::setAccount()
     * @uses RefundRequestType::setReference()
     * @uses RefundRequestType::setUserDefinedFields()
     * @param string $transactionId
     * @param string $merchantOrderId
     * @param int $amount
     * @param \StructType\PayGateAccountType $account
     * @param string $reference
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct($transactionId = null, $merchantOrderId = null, $amount = null, \StructType\PayGateAccountType $account = null, $reference = null, array $userDefinedFields = array())
    {
        $this
            ->setTransactionId($transactionId)
            ->setMerchantOrderId($merchantOrderId)
            ->setAmount($amount)
            ->setAccount($account)
            ->setReference($reference)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get TransactionId value
     * @return string
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\RefundRequestType
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get MerchantOrderId value
     * @return string
     */
    public function getMerchantOrderId()
    {
        return $this->MerchantOrderId;
    }
    /**
     * Set MerchantOrderId value
     * @param string $merchantOrderId
     * @return \StructType\RefundRequestType
     */
    public function setMerchantOrderId($merchantOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantOrderId) && !is_string($merchantOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantOrderId)), __LINE__);
        }
        $this->MerchantOrderId = $merchantOrderId;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\RefundRequestType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\RefundRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\RefundRequestType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\RefundRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        foreach ($userDefinedFields as $refundRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$refundRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($refundRequestTypeUserDefinedFieldsItem) ? get_class($refundRequestTypeUserDefinedFieldsItem) : gettype($refundRequestTypeUserDefinedFieldsItem)), __LINE__);
            }
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\RefundRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of \StructType\KeyValueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RefundRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
