<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringType StructType
 * @subpackage Structs
 */
class RecurringType extends AbstractStructBase
{
    /**
     * The InitialAuth
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InitialAuth;
    /**
     * The RecurringTransactionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecurringTransactionType;
    /**
     * The InitiatedType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InitiatedType;
    /**
     * The OriginalRecurringReferenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalRecurringReferenceID;
    /**
     * Constructor method for RecurringType
     * @uses RecurringType::setInitialAuth()
     * @uses RecurringType::setRecurringTransactionType()
     * @uses RecurringType::setInitiatedType()
     * @uses RecurringType::setOriginalRecurringReferenceID()
     * @param bool $initialAuth
     * @param string $recurringTransactionType
     * @param string $initiatedType
     * @param string $originalRecurringReferenceID
     */
    public function __construct($initialAuth = false, $recurringTransactionType = null, $initiatedType = null, $originalRecurringReferenceID = null)
    {
        $this
            ->setInitialAuth($initialAuth)
            ->setRecurringTransactionType($recurringTransactionType)
            ->setInitiatedType($initiatedType)
            ->setOriginalRecurringReferenceID($originalRecurringReferenceID);
    }
    /**
     * Get InitialAuth value
     * @return bool|null
     */
    public function getInitialAuth()
    {
        return $this->InitialAuth;
    }
    /**
     * Set InitialAuth value
     * @param bool $initialAuth
     * @return \StructType\RecurringType
     */
    public function setInitialAuth($initialAuth = false)
    {
        // validation for constraint: boolean
        if (!is_null($initialAuth) && !is_bool($initialAuth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($initialAuth, true), gettype($initialAuth)), __LINE__);
        }
        $this->InitialAuth = $initialAuth;
        return $this;
    }
    /**
     * Get RecurringTransactionType value
     * @return string|null
     */
    public function getRecurringTransactionType()
    {
        return $this->RecurringTransactionType;
    }
    /**
     * Set RecurringTransactionType value
     * @uses \EnumType\RecurringTransactionType::valueIsValid()
     * @uses \EnumType\RecurringTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurringTransactionType
     * @return \StructType\RecurringType
     */
    public function setRecurringTransactionType($recurringTransactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecurringTransactionType::valueIsValid($recurringTransactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RecurringTransactionType', is_array($recurringTransactionType) ? implode(', ', $recurringTransactionType) : var_export($recurringTransactionType, true), implode(', ', \EnumType\RecurringTransactionType::getValidValues())), __LINE__);
        }
        $this->RecurringTransactionType = $recurringTransactionType;
        return $this;
    }
    /**
     * Get InitiatedType value
     * @return string|null
     */
    public function getInitiatedType()
    {
        return $this->InitiatedType;
    }
    /**
     * Set InitiatedType value
     * @uses \EnumType\InitiatedType::valueIsValid()
     * @uses \EnumType\InitiatedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $initiatedType
     * @return \StructType\RecurringType
     */
    public function setInitiatedType($initiatedType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiatedType::valueIsValid($initiatedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InitiatedType', is_array($initiatedType) ? implode(', ', $initiatedType) : var_export($initiatedType, true), implode(', ', \EnumType\InitiatedType::getValidValues())), __LINE__);
        }
        $this->InitiatedType = $initiatedType;
        return $this;
    }
    /**
     * Get OriginalRecurringReferenceID value
     * @return string|null
     */
    public function getOriginalRecurringReferenceID()
    {
        return $this->OriginalRecurringReferenceID;
    }
    /**
     * Set OriginalRecurringReferenceID value
     * @param string $originalRecurringReferenceID
     * @return \StructType\RecurringType
     */
    public function setOriginalRecurringReferenceID($originalRecurringReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($originalRecurringReferenceID) && !is_string($originalRecurringReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalRecurringReferenceID, true), gettype($originalRecurringReferenceID)), __LINE__);
        }
        $this->OriginalRecurringReferenceID = $originalRecurringReferenceID;
        return $this;
    }
}
