<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilitatorType StructType
 * @subpackage Structs
 */
class FacilitatorType extends AbstractStructBase
{
    /**
     * The PaymentFacilitatorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentFacilitatorId;
    /**
     * The AcceptorTaxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcceptorTaxId;
    /**
     * The SubMerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubMerchantId;
    /**
     * The SubMerchantName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubMerchantName;
    /**
     * The SubMerchantTaxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubMerchantTaxId;
    /**
     * The IndependentSaleOrg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndependentSaleOrg;
    /**
     * The FacilitatorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FacilitatorName;
    /**
     * Constructor method for FacilitatorType
     * @uses FacilitatorType::setPaymentFacilitatorId()
     * @uses FacilitatorType::setAcceptorTaxId()
     * @uses FacilitatorType::setSubMerchantId()
     * @uses FacilitatorType::setSubMerchantName()
     * @uses FacilitatorType::setSubMerchantTaxId()
     * @uses FacilitatorType::setIndependentSaleOrg()
     * @uses FacilitatorType::setFacilitatorName()
     * @param string $paymentFacilitatorId
     * @param string $acceptorTaxId
     * @param string $subMerchantId
     * @param string $subMerchantName
     * @param string $subMerchantTaxId
     * @param string $independentSaleOrg
     * @param string $facilitatorName
     */
    public function __construct($paymentFacilitatorId = null, $acceptorTaxId = null, $subMerchantId = null, $subMerchantName = null, $subMerchantTaxId = null, $independentSaleOrg = null, $facilitatorName = null)
    {
        $this
            ->setPaymentFacilitatorId($paymentFacilitatorId)
            ->setAcceptorTaxId($acceptorTaxId)
            ->setSubMerchantId($subMerchantId)
            ->setSubMerchantName($subMerchantName)
            ->setSubMerchantTaxId($subMerchantTaxId)
            ->setIndependentSaleOrg($independentSaleOrg)
            ->setFacilitatorName($facilitatorName);
    }
    /**
     * Get PaymentFacilitatorId value
     * @return string|null
     */
    public function getPaymentFacilitatorId()
    {
        return $this->PaymentFacilitatorId;
    }
    /**
     * Set PaymentFacilitatorId value
     * @param string $paymentFacilitatorId
     * @return \StructType\FacilitatorType
     */
    public function setPaymentFacilitatorId($paymentFacilitatorId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentFacilitatorId) && !is_string($paymentFacilitatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentFacilitatorId, true), gettype($paymentFacilitatorId)), __LINE__);
        }
        $this->PaymentFacilitatorId = $paymentFacilitatorId;
        return $this;
    }
    /**
     * Get AcceptorTaxId value
     * @return string|null
     */
    public function getAcceptorTaxId()
    {
        return $this->AcceptorTaxId;
    }
    /**
     * Set AcceptorTaxId value
     * @param string $acceptorTaxId
     * @return \StructType\FacilitatorType
     */
    public function setAcceptorTaxId($acceptorTaxId = null)
    {
        // validation for constraint: string
        if (!is_null($acceptorTaxId) && !is_string($acceptorTaxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptorTaxId, true), gettype($acceptorTaxId)), __LINE__);
        }
        $this->AcceptorTaxId = $acceptorTaxId;
        return $this;
    }
    /**
     * Get SubMerchantId value
     * @return string|null
     */
    public function getSubMerchantId()
    {
        return $this->SubMerchantId;
    }
    /**
     * Set SubMerchantId value
     * @param string $subMerchantId
     * @return \StructType\FacilitatorType
     */
    public function setSubMerchantId($subMerchantId = null)
    {
        // validation for constraint: string
        if (!is_null($subMerchantId) && !is_string($subMerchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subMerchantId, true), gettype($subMerchantId)), __LINE__);
        }
        $this->SubMerchantId = $subMerchantId;
        return $this;
    }
    /**
     * Get SubMerchantName value
     * @return string|null
     */
    public function getSubMerchantName()
    {
        return $this->SubMerchantName;
    }
    /**
     * Set SubMerchantName value
     * @param string $subMerchantName
     * @return \StructType\FacilitatorType
     */
    public function setSubMerchantName($subMerchantName = null)
    {
        // validation for constraint: string
        if (!is_null($subMerchantName) && !is_string($subMerchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subMerchantName, true), gettype($subMerchantName)), __LINE__);
        }
        $this->SubMerchantName = $subMerchantName;
        return $this;
    }
    /**
     * Get SubMerchantTaxId value
     * @return string|null
     */
    public function getSubMerchantTaxId()
    {
        return $this->SubMerchantTaxId;
    }
    /**
     * Set SubMerchantTaxId value
     * @param string $subMerchantTaxId
     * @return \StructType\FacilitatorType
     */
    public function setSubMerchantTaxId($subMerchantTaxId = null)
    {
        // validation for constraint: string
        if (!is_null($subMerchantTaxId) && !is_string($subMerchantTaxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subMerchantTaxId, true), gettype($subMerchantTaxId)), __LINE__);
        }
        $this->SubMerchantTaxId = $subMerchantTaxId;
        return $this;
    }
    /**
     * Get IndependentSaleOrg value
     * @return string|null
     */
    public function getIndependentSaleOrg()
    {
        return $this->IndependentSaleOrg;
    }
    /**
     * Set IndependentSaleOrg value
     * @param string $independentSaleOrg
     * @return \StructType\FacilitatorType
     */
    public function setIndependentSaleOrg($independentSaleOrg = null)
    {
        // validation for constraint: string
        if (!is_null($independentSaleOrg) && !is_string($independentSaleOrg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($independentSaleOrg, true), gettype($independentSaleOrg)), __LINE__);
        }
        $this->IndependentSaleOrg = $independentSaleOrg;
        return $this;
    }
    /**
     * Get FacilitatorName value
     * @return string|null
     */
    public function getFacilitatorName()
    {
        return $this->FacilitatorName;
    }
    /**
     * Set FacilitatorName value
     * @param string $facilitatorName
     * @return \StructType\FacilitatorType
     */
    public function setFacilitatorName($facilitatorName = null)
    {
        // validation for constraint: string
        if (!is_null($facilitatorName) && !is_string($facilitatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilitatorName, true), gettype($facilitatorName)), __LINE__);
        }
        $this->FacilitatorName = $facilitatorName;
        return $this;
    }
}
