<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderType StructType
 * @subpackage Structs
 */
class OrderType extends AbstractStructBase
{
    /**
     * The MerchantOrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantOrderId;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Amount;
    /**
     * The CurrencyFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyFrom;
    /**
     * The ConversionRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ConversionRate;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Discount;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionDate;
    /**
     * The BillingDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingDetailsType
     */
    public $BillingDetails;
    /**
     * The ShippingDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShippingDetailsType
     */
    public $ShippingDetails;
    /**
     * The AirlineBookingDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AirlineBookingDetailsType
     */
    public $AirlineBookingDetails;
    /**
     * The OrderItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderItemType[]
     */
    public $OrderItems;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*
     * @var string
     */
    public $Locale;
    /**
     * Constructor method for OrderType
     * @uses OrderType::setMerchantOrderId()
     * @uses OrderType::setCurrency()
     * @uses OrderType::setAmount()
     * @uses OrderType::setCurrencyFrom()
     * @uses OrderType::setConversionRate()
     * @uses OrderType::setDiscount()
     * @uses OrderType::setTransactionDate()
     * @uses OrderType::setBillingDetails()
     * @uses OrderType::setShippingDetails()
     * @uses OrderType::setAirlineBookingDetails()
     * @uses OrderType::setOrderItems()
     * @uses OrderType::setLocale()
     * @param string $merchantOrderId
     * @param string $currency
     * @param int $amount
     * @param string $currencyFrom
     * @param float $conversionRate
     * @param int $discount
     * @param string $transactionDate
     * @param \StructType\BillingDetailsType $billingDetails
     * @param \StructType\ShippingDetailsType $shippingDetails
     * @param \StructType\AirlineBookingDetailsType $airlineBookingDetails
     * @param \StructType\OrderItemType[] $orderItems
     * @param string $locale
     */
    public function __construct($merchantOrderId = null, $currency = null, $amount = null, $currencyFrom = null, $conversionRate = null, $discount = null, $transactionDate = null, \StructType\BillingDetailsType $billingDetails = null, \StructType\ShippingDetailsType $shippingDetails = null, \StructType\AirlineBookingDetailsType $airlineBookingDetails = null, array $orderItems = array(), $locale = null)
    {
        $this
            ->setMerchantOrderId($merchantOrderId)
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setCurrencyFrom($currencyFrom)
            ->setConversionRate($conversionRate)
            ->setDiscount($discount)
            ->setTransactionDate($transactionDate)
            ->setBillingDetails($billingDetails)
            ->setShippingDetails($shippingDetails)
            ->setAirlineBookingDetails($airlineBookingDetails)
            ->setOrderItems($orderItems)
            ->setLocale($locale);
    }
    /**
     * Get MerchantOrderId value
     * @return string
     */
    public function getMerchantOrderId()
    {
        return $this->MerchantOrderId;
    }
    /**
     * Set MerchantOrderId value
     * @param string $merchantOrderId
     * @return \StructType\OrderType
     */
    public function setMerchantOrderId($merchantOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantOrderId) && !is_string($merchantOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantOrderId, true), gettype($merchantOrderId)), __LINE__);
        }
        $this->MerchantOrderId = $merchantOrderId;
        return $this;
    }
    /**
     * Get Currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\OrderType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyType', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\OrderType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyFrom value
     * @return string|null
     */
    public function getCurrencyFrom()
    {
        return $this->CurrencyFrom;
    }
    /**
     * Set CurrencyFrom value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyFrom
     * @return \StructType\OrderType
     */
    public function setCurrencyFrom($currencyFrom = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($currencyFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyType', is_array($currencyFrom) ? implode(', ', $currencyFrom) : var_export($currencyFrom, true), implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->CurrencyFrom = $currencyFrom;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return float|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param float $conversionRate
     * @return \StructType\OrderType
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: float
        if (!is_null($conversionRate) && !(is_float($conversionRate) || is_numeric($conversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get Discount value
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param int $discount
     * @return \StructType\OrderType
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: int
        if (!is_null($discount) && !(is_int($discount) || ctype_digit($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\OrderType
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get BillingDetails value
     * @return \StructType\BillingDetailsType|null
     */
    public function getBillingDetails()
    {
        return $this->BillingDetails;
    }
    /**
     * Set BillingDetails value
     * @param \StructType\BillingDetailsType $billingDetails
     * @return \StructType\OrderType
     */
    public function setBillingDetails(\StructType\BillingDetailsType $billingDetails = null)
    {
        $this->BillingDetails = $billingDetails;
        return $this;
    }
    /**
     * Get ShippingDetails value
     * @return \StructType\ShippingDetailsType|null
     */
    public function getShippingDetails()
    {
        return $this->ShippingDetails;
    }
    /**
     * Set ShippingDetails value
     * @param \StructType\ShippingDetailsType $shippingDetails
     * @return \StructType\OrderType
     */
    public function setShippingDetails(\StructType\ShippingDetailsType $shippingDetails = null)
    {
        $this->ShippingDetails = $shippingDetails;
        return $this;
    }
    /**
     * Get AirlineBookingDetails value
     * @return \StructType\AirlineBookingDetailsType|null
     */
    public function getAirlineBookingDetails()
    {
        return $this->AirlineBookingDetails;
    }
    /**
     * Set AirlineBookingDetails value
     * @param \StructType\AirlineBookingDetailsType $airlineBookingDetails
     * @return \StructType\OrderType
     */
    public function setAirlineBookingDetails(\StructType\AirlineBookingDetailsType $airlineBookingDetails = null)
    {
        $this->AirlineBookingDetails = $airlineBookingDetails;
        return $this;
    }
    /**
     * Get OrderItems value
     * @return \StructType\OrderItemType[]|null
     */
    public function getOrderItems()
    {
        return $this->OrderItems;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemsForArrayConstraintsFromSetOrderItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderTypeOrderItemsItem) {
            // validation for constraint: itemType
            if (!$orderTypeOrderItemsItem instanceof \StructType\OrderItemType) {
                $invalidValues[] = is_object($orderTypeOrderItemsItem) ? get_class($orderTypeOrderItemsItem) : sprintf('%s(%s)', gettype($orderTypeOrderItemsItem), var_export($orderTypeOrderItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItems property can only contain items of type \StructType\OrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItems value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemType[] $orderItems
     * @return \StructType\OrderType
     */
    public function setOrderItems(array $orderItems = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemsArrayErrorMessage = self::validateOrderItemsForArrayConstraintsFromSetOrderItems($orderItems))) {
            throw new \InvalidArgumentException($orderItemsArrayErrorMessage, __LINE__);
        }
        $this->OrderItems = $orderItems;
        return $this;
    }
    /**
     * Add item to OrderItems value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemType $item
     * @return \StructType\OrderType
     */
    public function addToOrderItems(\StructType\OrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemType) {
            throw new \InvalidArgumentException(sprintf('The OrderItems property can only contain items of type \StructType\OrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItems[] = $item;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \StructType\OrderType
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        // validation for constraint: pattern(([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*)
        if (!is_null($locale) && !preg_match('/([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*/', $locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*', var_export($locale, true)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
}
