<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusType StructType
 * @subpackage Structs
 */
class StatusType extends AbstractStructBase
{
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The AcquirerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcquirerCode;
    /**
     * The StatusName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusName;
    /**
     * The StatusDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDetail;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The PayRequestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayRequestId;
    /**
     * The VaultId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VaultId;
    /**
     * The PayVaultData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VaultDataType[]
     */
    public $PayVaultData;
    /**
     * The TransactionStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The TransactionStatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionStatusDescription;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultDescription;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * The RequestedCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestedCurrency;
    /**
     * The RequestedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $RequestedAmount;
    /**
     * The ConversionRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConversionRate;
    /**
     * The RiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RiskIndicator;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentType
     */
    public $PaymentType;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionType;
    /**
     * The OriginalRecurringBankReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalRecurringBankReference;
    /**
     * The ThreeDSecureDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureDetailsType
     */
    public $ThreeDSecureDetails;
    /**
     * The RiskDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskDetailsType
     */
    public $RiskDetails;
    /**
     * Constructor method for StatusType
     * @uses StatusType::setTransactionId()
     * @uses StatusType::setReference()
     * @uses StatusType::setAcquirerCode()
     * @uses StatusType::setStatusName()
     * @uses StatusType::setStatusDetail()
     * @uses StatusType::setAuthCode()
     * @uses StatusType::setPayRequestId()
     * @uses StatusType::setVaultId()
     * @uses StatusType::setPayVaultData()
     * @uses StatusType::setTransactionStatusCode()
     * @uses StatusType::setTransactionStatusDescription()
     * @uses StatusType::setResultCode()
     * @uses StatusType::setResultDescription()
     * @uses StatusType::setCurrency()
     * @uses StatusType::setAmount()
     * @uses StatusType::setRequestedCurrency()
     * @uses StatusType::setRequestedAmount()
     * @uses StatusType::setConversionRate()
     * @uses StatusType::setRiskIndicator()
     * @uses StatusType::setPaymentType()
     * @uses StatusType::setBillingDescriptor()
     * @uses StatusType::setDateTime()
     * @uses StatusType::setTransactionType()
     * @uses StatusType::setOriginalRecurringBankReference()
     * @uses StatusType::setThreeDSecureDetails()
     * @uses StatusType::setRiskDetails()
     * @param string $transactionId
     * @param string $reference
     * @param string $acquirerCode
     * @param string $statusName
     * @param string $statusDetail
     * @param string $authCode
     * @param string $payRequestId
     * @param string $vaultId
     * @param \StructType\VaultDataType[] $payVaultData
     * @param string $transactionStatusCode
     * @param string $transactionStatusDescription
     * @param string $resultCode
     * @param string $resultDescription
     * @param string $currency
     * @param int $amount
     * @param string $requestedCurrency
     * @param int $requestedAmount
     * @param string $conversionRate
     * @param string $riskIndicator
     * @param \StructType\PaymentType $paymentType
     * @param string $billingDescriptor
     * @param string $dateTime
     * @param string $transactionType
     * @param string $originalRecurringBankReference
     * @param \StructType\ThreeDSecureDetailsType $threeDSecureDetails
     * @param \StructType\RiskDetailsType $riskDetails
     */
    public function __construct($transactionId = null, $reference = null, $acquirerCode = null, $statusName = null, $statusDetail = null, $authCode = null, $payRequestId = null, $vaultId = null, array $payVaultData = array(), $transactionStatusCode = null, $transactionStatusDescription = null, $resultCode = null, $resultDescription = null, $currency = null, $amount = null, $requestedCurrency = null, $requestedAmount = null, $conversionRate = null, $riskIndicator = null, \StructType\PaymentType $paymentType = null, $billingDescriptor = null, $dateTime = null, $transactionType = null, $originalRecurringBankReference = null, \StructType\ThreeDSecureDetailsType $threeDSecureDetails = null, \StructType\RiskDetailsType $riskDetails = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setReference($reference)
            ->setAcquirerCode($acquirerCode)
            ->setStatusName($statusName)
            ->setStatusDetail($statusDetail)
            ->setAuthCode($authCode)
            ->setPayRequestId($payRequestId)
            ->setVaultId($vaultId)
            ->setPayVaultData($payVaultData)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setTransactionStatusDescription($transactionStatusDescription)
            ->setResultCode($resultCode)
            ->setResultDescription($resultDescription)
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setRequestedCurrency($requestedCurrency)
            ->setRequestedAmount($requestedAmount)
            ->setConversionRate($conversionRate)
            ->setRiskIndicator($riskIndicator)
            ->setPaymentType($paymentType)
            ->setBillingDescriptor($billingDescriptor)
            ->setDateTime($dateTime)
            ->setTransactionType($transactionType)
            ->setOriginalRecurringBankReference($originalRecurringBankReference)
            ->setThreeDSecureDetails($threeDSecureDetails)
            ->setRiskDetails($riskDetails);
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\StatusType
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\StatusType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get AcquirerCode value
     * @return string|null
     */
    public function getAcquirerCode()
    {
        return $this->AcquirerCode;
    }
    /**
     * Set AcquirerCode value
     * @param string $acquirerCode
     * @return \StructType\StatusType
     */
    public function setAcquirerCode($acquirerCode = null)
    {
        // validation for constraint: string
        if (!is_null($acquirerCode) && !is_string($acquirerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquirerCode, true), gettype($acquirerCode)), __LINE__);
        }
        $this->AcquirerCode = $acquirerCode;
        return $this;
    }
    /**
     * Get StatusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->StatusName;
    }
    /**
     * Set StatusName value
     * @uses \EnumType\StatusNameType::valueIsValid()
     * @uses \EnumType\StatusNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusName
     * @return \StructType\StatusType
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusNameType::valueIsValid($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusNameType', is_array($statusName) ? implode(', ', $statusName) : var_export($statusName, true), implode(', ', \EnumType\StatusNameType::getValidValues())), __LINE__);
        }
        $this->StatusName = $statusName;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return string|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param string $statusDetail
     * @return \StructType\StatusType
     */
    public function setStatusDetail($statusDetail = null)
    {
        // validation for constraint: string
        if (!is_null($statusDetail) && !is_string($statusDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDetail, true), gettype($statusDetail)), __LINE__);
        }
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\StatusType
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get PayRequestId value
     * @return string|null
     */
    public function getPayRequestId()
    {
        return $this->PayRequestId;
    }
    /**
     * Set PayRequestId value
     * @param string $payRequestId
     * @return \StructType\StatusType
     */
    public function setPayRequestId($payRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($payRequestId) && !is_string($payRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payRequestId, true), gettype($payRequestId)), __LINE__);
        }
        $this->PayRequestId = $payRequestId;
        return $this;
    }
    /**
     * Get VaultId value
     * @return string|null
     */
    public function getVaultId()
    {
        return $this->VaultId;
    }
    /**
     * Set VaultId value
     * @param string $vaultId
     * @return \StructType\StatusType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vaultId, true), gettype($vaultId)), __LINE__);
        }
        $this->VaultId = $vaultId;
        return $this;
    }
    /**
     * Get PayVaultData value
     * @return \StructType\VaultDataType[]|null
     */
    public function getPayVaultData()
    {
        return $this->PayVaultData;
    }
    /**
     * This method is responsible for validating the values passed to the setPayVaultData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayVaultData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayVaultDataForArrayConstraintsFromSetPayVaultData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusTypePayVaultDataItem) {
            // validation for constraint: itemType
            if (!$statusTypePayVaultDataItem instanceof \StructType\VaultDataType) {
                $invalidValues[] = is_object($statusTypePayVaultDataItem) ? get_class($statusTypePayVaultDataItem) : sprintf('%s(%s)', gettype($statusTypePayVaultDataItem), var_export($statusTypePayVaultDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PayVaultData property can only contain items of type \StructType\VaultDataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PayVaultData value
     * @throws \InvalidArgumentException
     * @param \StructType\VaultDataType[] $payVaultData
     * @return \StructType\StatusType
     */
    public function setPayVaultData(array $payVaultData = array())
    {
        // validation for constraint: array
        if ('' !== ($payVaultDataArrayErrorMessage = self::validatePayVaultDataForArrayConstraintsFromSetPayVaultData($payVaultData))) {
            throw new \InvalidArgumentException($payVaultDataArrayErrorMessage, __LINE__);
        }
        $this->PayVaultData = $payVaultData;
        return $this;
    }
    /**
     * Add item to PayVaultData value
     * @throws \InvalidArgumentException
     * @param \StructType\VaultDataType $item
     * @return \StructType\StatusType
     */
    public function addToPayVaultData(\StructType\VaultDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VaultDataType) {
            throw new \InvalidArgumentException(sprintf('The PayVaultData property can only contain items of type \StructType\VaultDataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PayVaultData[] = $item;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\StatusType
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get TransactionStatusDescription value
     * @return string|null
     */
    public function getTransactionStatusDescription()
    {
        return $this->TransactionStatusDescription;
    }
    /**
     * Set TransactionStatusDescription value
     * @param string $transactionStatusDescription
     * @return \StructType\StatusType
     */
    public function setTransactionStatusDescription($transactionStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusDescription) && !is_string($transactionStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusDescription, true), gettype($transactionStatusDescription)), __LINE__);
        }
        $this->TransactionStatusDescription = $transactionStatusDescription;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\StatusType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultDescription value
     * @return string|null
     */
    public function getResultDescription()
    {
        return $this->ResultDescription;
    }
    /**
     * Set ResultDescription value
     * @param string $resultDescription
     * @return \StructType\StatusType
     */
    public function setResultDescription($resultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($resultDescription) && !is_string($resultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultDescription, true), gettype($resultDescription)), __LINE__);
        }
        $this->ResultDescription = $resultDescription;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\StatusType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyType', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\StatusType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get RequestedCurrency value
     * @return string|null
     */
    public function getRequestedCurrency()
    {
        return $this->RequestedCurrency;
    }
    /**
     * Set RequestedCurrency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedCurrency
     * @return \StructType\StatusType
     */
    public function setRequestedCurrency($requestedCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($requestedCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyType', is_array($requestedCurrency) ? implode(', ', $requestedCurrency) : var_export($requestedCurrency, true), implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->RequestedCurrency = $requestedCurrency;
        return $this;
    }
    /**
     * Get RequestedAmount value
     * @return int|null
     */
    public function getRequestedAmount()
    {
        return $this->RequestedAmount;
    }
    /**
     * Set RequestedAmount value
     * @param int $requestedAmount
     * @return \StructType\StatusType
     */
    public function setRequestedAmount($requestedAmount = null)
    {
        // validation for constraint: int
        if (!is_null($requestedAmount) && !(is_int($requestedAmount) || ctype_digit($requestedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedAmount, true), gettype($requestedAmount)), __LINE__);
        }
        $this->RequestedAmount = $requestedAmount;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return string|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param string $conversionRate
     * @return \StructType\StatusType
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: string
        if (!is_null($conversionRate) && !is_string($conversionRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get RiskIndicator value
     * @return string|null
     */
    public function getRiskIndicator()
    {
        return $this->RiskIndicator;
    }
    /**
     * Set RiskIndicator value
     * @param string $riskIndicator
     * @return \StructType\StatusType
     */
    public function setRiskIndicator($riskIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($riskIndicator) && !is_string($riskIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($riskIndicator, true), gettype($riskIndicator)), __LINE__);
        }
        $this->RiskIndicator = $riskIndicator;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return \StructType\PaymentType|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param \StructType\PaymentType $paymentType
     * @return \StructType\StatusType
     */
    public function setPaymentType(\StructType\PaymentType $paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\StatusType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\StatusType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\StatusType
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get OriginalRecurringBankReference value
     * @return string|null
     */
    public function getOriginalRecurringBankReference()
    {
        return $this->OriginalRecurringBankReference;
    }
    /**
     * Set OriginalRecurringBankReference value
     * @param string $originalRecurringBankReference
     * @return \StructType\StatusType
     */
    public function setOriginalRecurringBankReference($originalRecurringBankReference = null)
    {
        // validation for constraint: string
        if (!is_null($originalRecurringBankReference) && !is_string($originalRecurringBankReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalRecurringBankReference, true), gettype($originalRecurringBankReference)), __LINE__);
        }
        $this->OriginalRecurringBankReference = $originalRecurringBankReference;
        return $this;
    }
    /**
     * Get ThreeDSecureDetails value
     * @return \StructType\ThreeDSecureDetailsType|null
     */
    public function getThreeDSecureDetails()
    {
        return $this->ThreeDSecureDetails;
    }
    /**
     * Set ThreeDSecureDetails value
     * @param \StructType\ThreeDSecureDetailsType $threeDSecureDetails
     * @return \StructType\StatusType
     */
    public function setThreeDSecureDetails(\StructType\ThreeDSecureDetailsType $threeDSecureDetails = null)
    {
        $this->ThreeDSecureDetails = $threeDSecureDetails;
        return $this;
    }
    /**
     * Get RiskDetails value
     * @return \StructType\RiskDetailsType|null
     */
    public function getRiskDetails()
    {
        return $this->RiskDetails;
    }
    /**
     * Set RiskDetails value
     * @param \StructType\RiskDetailsType $riskDetails
     * @return \StructType\StatusType
     */
    public function setRiskDetails(\StructType\RiskDetailsType $riskDetails = null)
    {
        $this->RiskDetails = $riskDetails;
        return $this;
    }
}
