<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeolocationType StructType
 * @subpackage Structs
 */
class GeolocationType extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $State;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Country;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zip;
    /**
     * The MSISDN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MSISDN;
    /**
     * The CustomerServiceMSISDN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerServiceMSISDN;
    /**
     * The AdditionalContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalContactInformation;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for GeolocationType
     * @uses GeolocationType::setAddress()
     * @uses GeolocationType::setCity()
     * @uses GeolocationType::setState()
     * @uses GeolocationType::setCountry()
     * @uses GeolocationType::setZip()
     * @uses GeolocationType::setMSISDN()
     * @uses GeolocationType::setCustomerServiceMSISDN()
     * @uses GeolocationType::setAdditionalContactInformation()
     * @uses GeolocationType::setURL()
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $country
     * @param string $zip
     * @param string $mSISDN
     * @param string $customerServiceMSISDN
     * @param string $additionalContactInformation
     * @param string $uRL
     */
    public function __construct($address = null, $city = null, $state = null, $country = null, $zip = null, $mSISDN = null, $customerServiceMSISDN = null, $additionalContactInformation = null, $uRL = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country)
            ->setZip($zip)
            ->setMSISDN($mSISDN)
            ->setCustomerServiceMSISDN($customerServiceMSISDN)
            ->setAdditionalContactInformation($additionalContactInformation)
            ->setURL($uRL);
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\GeolocationType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\GeolocationType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\GeolocationType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\GeolocationType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryType', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Zip value
     * @return string
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\GeolocationType
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get MSISDN value
     * @return string
     */
    public function getMSISDN()
    {
        return $this->MSISDN;
    }
    /**
     * Set MSISDN value
     * @param string $mSISDN
     * @return \StructType\GeolocationType
     */
    public function setMSISDN($mSISDN = null)
    {
        // validation for constraint: string
        if (!is_null($mSISDN) && !is_string($mSISDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mSISDN, true), gettype($mSISDN)), __LINE__);
        }
        $this->MSISDN = $mSISDN;
        return $this;
    }
    /**
     * Get CustomerServiceMSISDN value
     * @return string|null
     */
    public function getCustomerServiceMSISDN()
    {
        return $this->CustomerServiceMSISDN;
    }
    /**
     * Set CustomerServiceMSISDN value
     * @param string $customerServiceMSISDN
     * @return \StructType\GeolocationType
     */
    public function setCustomerServiceMSISDN($customerServiceMSISDN = null)
    {
        // validation for constraint: string
        if (!is_null($customerServiceMSISDN) && !is_string($customerServiceMSISDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerServiceMSISDN, true), gettype($customerServiceMSISDN)), __LINE__);
        }
        $this->CustomerServiceMSISDN = $customerServiceMSISDN;
        return $this;
    }
    /**
     * Get AdditionalContactInformation value
     * @return string|null
     */
    public function getAdditionalContactInformation()
    {
        return $this->AdditionalContactInformation;
    }
    /**
     * Set AdditionalContactInformation value
     * @param string $additionalContactInformation
     * @return \StructType\GeolocationType
     */
    public function setAdditionalContactInformation($additionalContactInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalContactInformation) && !is_string($additionalContactInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalContactInformation, true), gettype($additionalContactInformation)), __LINE__);
        }
        $this->AdditionalContactInformation = $additionalContactInformation;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\GeolocationType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
