<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskDetailsType StructType
 * @subpackage Structs
 */
class RiskDetailsType extends AbstractStructBase
{
    /**
     * The MerchantAdviseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantAdviseCode;
    /**
     * The BlockStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskBlockStatusType
     */
    public $BlockStatus;
    /**
     * Constructor method for RiskDetailsType
     * @uses RiskDetailsType::setMerchantAdviseCode()
     * @uses RiskDetailsType::setBlockStatus()
     * @param string $merchantAdviseCode
     * @param \StructType\RiskBlockStatusType $blockStatus
     */
    public function __construct($merchantAdviseCode = null, \StructType\RiskBlockStatusType $blockStatus = null)
    {
        $this
            ->setMerchantAdviseCode($merchantAdviseCode)
            ->setBlockStatus($blockStatus);
    }
    /**
     * Get MerchantAdviseCode value
     * @return string|null
     */
    public function getMerchantAdviseCode()
    {
        return $this->MerchantAdviseCode;
    }
    /**
     * Set MerchantAdviseCode value
     * @param string $merchantAdviseCode
     * @return \StructType\RiskDetailsType
     */
    public function setMerchantAdviseCode($merchantAdviseCode = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAdviseCode) && !is_string($merchantAdviseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAdviseCode, true), gettype($merchantAdviseCode)), __LINE__);
        }
        $this->MerchantAdviseCode = $merchantAdviseCode;
        return $this;
    }
    /**
     * Get BlockStatus value
     * @return \StructType\RiskBlockStatusType|null
     */
    public function getBlockStatus()
    {
        return $this->BlockStatus;
    }
    /**
     * Set BlockStatus value
     * @param \StructType\RiskBlockStatusType $blockStatus
     * @return \StructType\RiskDetailsType
     */
    public function setBlockStatus(\StructType\RiskBlockStatusType $blockStatus = null)
    {
        $this->BlockStatus = $blockStatus;
        return $this;
    }
}
