<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountStatusInquiryRequestType StructType
 * @subpackage Structs
 */
class AccountStatusInquiryRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 19
     * - maxOccurs: 1
     * - minLength: 13
     * - minOccurs: 1
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The CardExpiryDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The CVV
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 3
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $CVV;
    /**
     * The Vault
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The AcquirerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AcquirerInfoType
     */
    public $AcquirerInfo;
    /**
     * The ThreeDSecure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureType
     */
    public $ThreeDSecure;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * The Recurring
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecurringType
     */
    public $Recurring;
    /**
     * The Facilitator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FacilitatorType
     */
    public $Facilitator;
    /**
     * The Geolocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeolocationType
     */
    public $Geolocation;
    /**
     * The ServiceGeolocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeolocationType
     */
    public $ServiceGeolocation;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for AccountStatusInquiryRequestType
     * @uses AccountStatusInquiryRequestType::setCustomer()
     * @uses AccountStatusInquiryRequestType::setCardNumber()
     * @uses AccountStatusInquiryRequestType::setAccount()
     * @uses AccountStatusInquiryRequestType::setCardExpiryDate()
     * @uses AccountStatusInquiryRequestType::setCVV()
     * @uses AccountStatusInquiryRequestType::setVault()
     * @uses AccountStatusInquiryRequestType::setRedirect()
     * @uses AccountStatusInquiryRequestType::setOrder()
     * @uses AccountStatusInquiryRequestType::setAcquirerInfo()
     * @uses AccountStatusInquiryRequestType::setThreeDSecure()
     * @uses AccountStatusInquiryRequestType::setBillingDescriptor()
     * @uses AccountStatusInquiryRequestType::setRecurring()
     * @uses AccountStatusInquiryRequestType::setFacilitator()
     * @uses AccountStatusInquiryRequestType::setGeolocation()
     * @uses AccountStatusInquiryRequestType::setServiceGeolocation()
     * @uses AccountStatusInquiryRequestType::setUserDefinedFields()
     * @param \StructType\PersonType $customer
     * @param string $cardNumber
     * @param \StructType\PayGateAccountType $account
     * @param string $cardExpiryDate
     * @param string $cVV
     * @param bool $vault
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\AcquirerInfoType $acquirerInfo
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @param string $billingDescriptor
     * @param \StructType\RecurringType $recurring
     * @param \StructType\FacilitatorType $facilitator
     * @param \StructType\GeolocationType $geolocation
     * @param \StructType\GeolocationType $serviceGeolocation
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\PersonType $customer = null, $cardNumber = null, \StructType\PayGateAccountType $account = null, $cardExpiryDate = null, $cVV = null, $vault = false, \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\AcquirerInfoType $acquirerInfo = null, \StructType\ThreeDSecureType $threeDSecure = null, $billingDescriptor = null, \StructType\RecurringType $recurring = null, \StructType\FacilitatorType $facilitator = null, \StructType\GeolocationType $geolocation = null, \StructType\GeolocationType $serviceGeolocation = null, array $userDefinedFields = array())
    {
        $this
            ->setCustomer($customer)
            ->setCardNumber($cardNumber)
            ->setAccount($account)
            ->setCardExpiryDate($cardExpiryDate)
            ->setCVV($cVV)
            ->setVault($vault)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setAcquirerInfo($acquirerInfo)
            ->setThreeDSecure($threeDSecure)
            ->setBillingDescriptor($billingDescriptor)
            ->setRecurring($recurring)
            ->setFacilitator($facilitator)
            ->setGeolocation($geolocation)
            ->setServiceGeolocation($serviceGeolocation)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9x]+)
        if (!is_null($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9x]+', var_export($cardNumber, true)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string|null
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiryDate, true), gettype($cardExpiryDate)), __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($cardExpiryDate, true)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get CVV value
     * @return string|null
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV, true), gettype($cVV)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($cVV) && mb_strlen($cVV) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($cVV)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($cVV) && mb_strlen($cVV) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($cVV)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($cVV) && !preg_match('/[0-9]+/', $cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($cVV, true)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vault, true), gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get AcquirerInfo value
     * @return \StructType\AcquirerInfoType|null
     */
    public function getAcquirerInfo()
    {
        return $this->AcquirerInfo;
    }
    /**
     * Set AcquirerInfo value
     * @param \StructType\AcquirerInfoType $acquirerInfo
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setAcquirerInfo(\StructType\AcquirerInfoType $acquirerInfo = null)
    {
        $this->AcquirerInfo = $acquirerInfo;
        return $this;
    }
    /**
     * Get ThreeDSecure value
     * @return \StructType\ThreeDSecureType|null
     */
    public function getThreeDSecure()
    {
        return $this->ThreeDSecure;
    }
    /**
     * Set ThreeDSecure value
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setThreeDSecure(\StructType\ThreeDSecureType $threeDSecure = null)
    {
        $this->ThreeDSecure = $threeDSecure;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Get Recurring value
     * @return \StructType\RecurringType|null
     */
    public function getRecurring()
    {
        return $this->Recurring;
    }
    /**
     * Set Recurring value
     * @param \StructType\RecurringType $recurring
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setRecurring(\StructType\RecurringType $recurring = null)
    {
        $this->Recurring = $recurring;
        return $this;
    }
    /**
     * Get Facilitator value
     * @return \StructType\FacilitatorType|null
     */
    public function getFacilitator()
    {
        return $this->Facilitator;
    }
    /**
     * Set Facilitator value
     * @param \StructType\FacilitatorType $facilitator
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setFacilitator(\StructType\FacilitatorType $facilitator = null)
    {
        $this->Facilitator = $facilitator;
        return $this;
    }
    /**
     * Get Geolocation value
     * @return \StructType\GeolocationType|null
     */
    public function getGeolocation()
    {
        return $this->Geolocation;
    }
    /**
     * Set Geolocation value
     * @param \StructType\GeolocationType $geolocation
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setGeolocation(\StructType\GeolocationType $geolocation = null)
    {
        $this->Geolocation = $geolocation;
        return $this;
    }
    /**
     * Get ServiceGeolocation value
     * @return \StructType\GeolocationType|null
     */
    public function getServiceGeolocation()
    {
        return $this->ServiceGeolocation;
    }
    /**
     * Set ServiceGeolocation value
     * @param \StructType\GeolocationType $serviceGeolocation
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setServiceGeolocation(\StructType\GeolocationType $serviceGeolocation = null)
    {
        $this->ServiceGeolocation = $serviceGeolocation;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountStatusInquiryRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$accountStatusInquiryRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($accountStatusInquiryRequestTypeUserDefinedFieldsItem) ? get_class($accountStatusInquiryRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($accountStatusInquiryRequestTypeUserDefinedFieldsItem), var_export($accountStatusInquiryRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\AccountStatusInquiryRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
}
