<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenizationInfoType StructType
 * @subpackage Structs
 */
class TokenizationInfoType extends AbstractStructBase
{
    /**
     * The TokenRequestorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TokenRequestorId;
    /**
     * The TokenExpiryDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $TokenExpiryDate;
    /**
     * The TokenCryptogram
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TokenCryptogram;
    /**
     * The MaskedCardNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{6}[\*]{6}\d{4}
     * @var string
     */
    public $MaskedCardNumber;
    /**
     * The CardExpiryDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The TokenEci
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TokenEci;
    /**
     * Constructor method for TokenizationInfoType
     * @uses TokenizationInfoType::setTokenRequestorId()
     * @uses TokenizationInfoType::setTokenExpiryDate()
     * @uses TokenizationInfoType::setTokenCryptogram()
     * @uses TokenizationInfoType::setMaskedCardNumber()
     * @uses TokenizationInfoType::setCardExpiryDate()
     * @uses TokenizationInfoType::setTokenEci()
     * @param string $tokenRequestorId
     * @param string $tokenExpiryDate
     * @param string $tokenCryptogram
     * @param string $maskedCardNumber
     * @param string $cardExpiryDate
     * @param string $tokenEci
     */
    public function __construct($tokenRequestorId = null, $tokenExpiryDate = null, $tokenCryptogram = null, $maskedCardNumber = null, $cardExpiryDate = null, $tokenEci = null)
    {
        $this
            ->setTokenRequestorId($tokenRequestorId)
            ->setTokenExpiryDate($tokenExpiryDate)
            ->setTokenCryptogram($tokenCryptogram)
            ->setMaskedCardNumber($maskedCardNumber)
            ->setCardExpiryDate($cardExpiryDate)
            ->setTokenEci($tokenEci);
    }
    /**
     * Get TokenRequestorId value
     * @return string
     */
    public function getTokenRequestorId()
    {
        return $this->TokenRequestorId;
    }
    /**
     * Set TokenRequestorId value
     * @param string $tokenRequestorId
     * @return \StructType\TokenizationInfoType
     */
    public function setTokenRequestorId($tokenRequestorId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenRequestorId) && !is_string($tokenRequestorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenRequestorId, true), gettype($tokenRequestorId)), __LINE__);
        }
        $this->TokenRequestorId = $tokenRequestorId;
        return $this;
    }
    /**
     * Get TokenExpiryDate value
     * @return string
     */
    public function getTokenExpiryDate()
    {
        return $this->TokenExpiryDate;
    }
    /**
     * Set TokenExpiryDate value
     * @param string $tokenExpiryDate
     * @return \StructType\TokenizationInfoType
     */
    public function setTokenExpiryDate($tokenExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($tokenExpiryDate) && !is_string($tokenExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenExpiryDate, true), gettype($tokenExpiryDate)), __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($tokenExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $tokenExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($tokenExpiryDate, true)), __LINE__);
        }
        $this->TokenExpiryDate = $tokenExpiryDate;
        return $this;
    }
    /**
     * Get TokenCryptogram value
     * @return string
     */
    public function getTokenCryptogram()
    {
        return $this->TokenCryptogram;
    }
    /**
     * Set TokenCryptogram value
     * @param string $tokenCryptogram
     * @return \StructType\TokenizationInfoType
     */
    public function setTokenCryptogram($tokenCryptogram = null)
    {
        // validation for constraint: string
        if (!is_null($tokenCryptogram) && !is_string($tokenCryptogram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenCryptogram, true), gettype($tokenCryptogram)), __LINE__);
        }
        $this->TokenCryptogram = $tokenCryptogram;
        return $this;
    }
    /**
     * Get MaskedCardNumber value
     * @return string
     */
    public function getMaskedCardNumber()
    {
        return $this->MaskedCardNumber;
    }
    /**
     * Set MaskedCardNumber value
     * @param string $maskedCardNumber
     * @return \StructType\TokenizationInfoType
     */
    public function setMaskedCardNumber($maskedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardNumber) && !is_string($maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedCardNumber, true), gettype($maskedCardNumber)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}[\*]{6}\d{4})
        if (!is_null($maskedCardNumber) && !preg_match('/\\d{6}[\\*]{6}\\d{4}/', $maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}[\*]{6}\d{4}', var_export($maskedCardNumber, true)), __LINE__);
        }
        $this->MaskedCardNumber = $maskedCardNumber;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\TokenizationInfoType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiryDate, true), gettype($cardExpiryDate)), __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($cardExpiryDate, true)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get TokenEci value
     * @return string|null
     */
    public function getTokenEci()
    {
        return $this->TokenEci;
    }
    /**
     * Set TokenEci value
     * @param string $tokenEci
     * @return \StructType\TokenizationInfoType
     */
    public function setTokenEci($tokenEci = null)
    {
        // validation for constraint: string
        if (!is_null($tokenEci) && !is_string($tokenEci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenEci, true), gettype($tokenEci)), __LINE__);
        }
        $this->TokenEci = $tokenEci;
        return $this;
    }
}
