<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenPaymentRequestType StructType
 * @subpackage Structs
 */
class TokenPaymentRequestType extends AbstractStructBase
{
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Token;
    /**
     * The TokenDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TokenDetail;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The VirtualCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VirtualCardType
     */
    public $VirtualCard;
    /**
     * The Vault
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The ThreeDSecure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureType
     */
    public $ThreeDSecure;
    /**
     * The Risk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskType
     */
    public $Risk;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Facilitator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FacilitatorType
     */
    public $Facilitator;
    /**
     * The Geolocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeolocationType
     */
    public $Geolocation;
    /**
     * The ServiceGeolocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeolocationType
     */
    public $ServiceGeolocation;
    /**
     * The AcquirerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AcquirerInfoType
     */
    public $AcquirerInfo;
    /**
     * The Recurring
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecurringType
     */
    public $Recurring;
    /**
     * The TokenizationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TokenizationInfoType
     */
    public $TokenizationInfo;
    /**
     * The CVV
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 3
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $CVV;
    /**
     * The BudgetPeriod
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $BudgetPeriod;
    /**
     * Constructor method for TokenPaymentRequestType
     * @uses TokenPaymentRequestType::setToken()
     * @uses TokenPaymentRequestType::setTokenDetail()
     * @uses TokenPaymentRequestType::setAccount()
     * @uses TokenPaymentRequestType::setCustomer()
     * @uses TokenPaymentRequestType::setVirtualCard()
     * @uses TokenPaymentRequestType::setVault()
     * @uses TokenPaymentRequestType::setRedirect()
     * @uses TokenPaymentRequestType::setOrder()
     * @uses TokenPaymentRequestType::setThreeDSecure()
     * @uses TokenPaymentRequestType::setRisk()
     * @uses TokenPaymentRequestType::setUserDefinedFields()
     * @uses TokenPaymentRequestType::setBillingDescriptor()
     * @uses TokenPaymentRequestType::setReference()
     * @uses TokenPaymentRequestType::setFacilitator()
     * @uses TokenPaymentRequestType::setGeolocation()
     * @uses TokenPaymentRequestType::setServiceGeolocation()
     * @uses TokenPaymentRequestType::setAcquirerInfo()
     * @uses TokenPaymentRequestType::setRecurring()
     * @uses TokenPaymentRequestType::setTokenizationInfo()
     * @uses TokenPaymentRequestType::setCVV()
     * @uses TokenPaymentRequestType::setBudgetPeriod()
     * @param string $token
     * @param string $tokenDetail
     * @param \StructType\PayGateAccountType $account
     * @param \StructType\PersonType $customer
     * @param \StructType\VirtualCardType $virtualCard
     * @param bool $vault
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @param \StructType\RiskType $risk
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @param string $billingDescriptor
     * @param string $reference
     * @param \StructType\FacilitatorType $facilitator
     * @param \StructType\GeolocationType $geolocation
     * @param \StructType\GeolocationType $serviceGeolocation
     * @param \StructType\AcquirerInfoType $acquirerInfo
     * @param \StructType\RecurringType $recurring
     * @param \StructType\TokenizationInfoType $tokenizationInfo
     * @param string $cVV
     * @param string $budgetPeriod
     */
    public function __construct($token = null, $tokenDetail = null, \StructType\PayGateAccountType $account = null, \StructType\PersonType $customer = null, \StructType\VirtualCardType $virtualCard = null, $vault = false, \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\ThreeDSecureType $threeDSecure = null, \StructType\RiskType $risk = null, array $userDefinedFields = array(), $billingDescriptor = null, $reference = null, \StructType\FacilitatorType $facilitator = null, \StructType\GeolocationType $geolocation = null, \StructType\GeolocationType $serviceGeolocation = null, \StructType\AcquirerInfoType $acquirerInfo = null, \StructType\RecurringType $recurring = null, \StructType\TokenizationInfoType $tokenizationInfo = null, $cVV = null, $budgetPeriod = null)
    {
        $this
            ->setToken($token)
            ->setTokenDetail($tokenDetail)
            ->setAccount($account)
            ->setCustomer($customer)
            ->setVirtualCard($virtualCard)
            ->setVault($vault)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setThreeDSecure($threeDSecure)
            ->setRisk($risk)
            ->setUserDefinedFields($userDefinedFields)
            ->setBillingDescriptor($billingDescriptor)
            ->setReference($reference)
            ->setFacilitator($facilitator)
            ->setGeolocation($geolocation)
            ->setServiceGeolocation($serviceGeolocation)
            ->setAcquirerInfo($acquirerInfo)
            ->setRecurring($recurring)
            ->setTokenizationInfo($tokenizationInfo)
            ->setCVV($cVV)
            ->setBudgetPeriod($budgetPeriod);
    }
    /**
     * Get Token value
     * @return string
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\TokenPaymentRequestType
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get TokenDetail value
     * @return string
     */
    public function getTokenDetail()
    {
        return $this->TokenDetail;
    }
    /**
     * Set TokenDetail value
     * @param string $tokenDetail
     * @return \StructType\TokenPaymentRequestType
     */
    public function setTokenDetail($tokenDetail = null)
    {
        // validation for constraint: string
        if (!is_null($tokenDetail) && !is_string($tokenDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenDetail, true), gettype($tokenDetail)), __LINE__);
        }
        $this->TokenDetail = $tokenDetail;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\TokenPaymentRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\TokenPaymentRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get VirtualCard value
     * @return \StructType\VirtualCardType|null
     */
    public function getVirtualCard()
    {
        return $this->VirtualCard;
    }
    /**
     * Set VirtualCard value
     * @param \StructType\VirtualCardType $virtualCard
     * @return \StructType\TokenPaymentRequestType
     */
    public function setVirtualCard(\StructType\VirtualCardType $virtualCard = null)
    {
        $this->VirtualCard = $virtualCard;
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\TokenPaymentRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vault, true), gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\TokenPaymentRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\TokenPaymentRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ThreeDSecure value
     * @return \StructType\ThreeDSecureType|null
     */
    public function getThreeDSecure()
    {
        return $this->ThreeDSecure;
    }
    /**
     * Set ThreeDSecure value
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @return \StructType\TokenPaymentRequestType
     */
    public function setThreeDSecure(\StructType\ThreeDSecureType $threeDSecure = null)
    {
        $this->ThreeDSecure = $threeDSecure;
        return $this;
    }
    /**
     * Get Risk value
     * @return \StructType\RiskType|null
     */
    public function getRisk()
    {
        return $this->Risk;
    }
    /**
     * Set Risk value
     * @param \StructType\RiskType $risk
     * @return \StructType\TokenPaymentRequestType
     */
    public function setRisk(\StructType\RiskType $risk = null)
    {
        $this->Risk = $risk;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tokenPaymentRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$tokenPaymentRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($tokenPaymentRequestTypeUserDefinedFieldsItem) ? get_class($tokenPaymentRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($tokenPaymentRequestTypeUserDefinedFieldsItem), var_export($tokenPaymentRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\TokenPaymentRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\TokenPaymentRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\TokenPaymentRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\TokenPaymentRequestType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Facilitator value
     * @return \StructType\FacilitatorType|null
     */
    public function getFacilitator()
    {
        return $this->Facilitator;
    }
    /**
     * Set Facilitator value
     * @param \StructType\FacilitatorType $facilitator
     * @return \StructType\TokenPaymentRequestType
     */
    public function setFacilitator(\StructType\FacilitatorType $facilitator = null)
    {
        $this->Facilitator = $facilitator;
        return $this;
    }
    /**
     * Get Geolocation value
     * @return \StructType\GeolocationType|null
     */
    public function getGeolocation()
    {
        return $this->Geolocation;
    }
    /**
     * Set Geolocation value
     * @param \StructType\GeolocationType $geolocation
     * @return \StructType\TokenPaymentRequestType
     */
    public function setGeolocation(\StructType\GeolocationType $geolocation = null)
    {
        $this->Geolocation = $geolocation;
        return $this;
    }
    /**
     * Get ServiceGeolocation value
     * @return \StructType\GeolocationType|null
     */
    public function getServiceGeolocation()
    {
        return $this->ServiceGeolocation;
    }
    /**
     * Set ServiceGeolocation value
     * @param \StructType\GeolocationType $serviceGeolocation
     * @return \StructType\TokenPaymentRequestType
     */
    public function setServiceGeolocation(\StructType\GeolocationType $serviceGeolocation = null)
    {
        $this->ServiceGeolocation = $serviceGeolocation;
        return $this;
    }
    /**
     * Get AcquirerInfo value
     * @return \StructType\AcquirerInfoType|null
     */
    public function getAcquirerInfo()
    {
        return $this->AcquirerInfo;
    }
    /**
     * Set AcquirerInfo value
     * @param \StructType\AcquirerInfoType $acquirerInfo
     * @return \StructType\TokenPaymentRequestType
     */
    public function setAcquirerInfo(\StructType\AcquirerInfoType $acquirerInfo = null)
    {
        $this->AcquirerInfo = $acquirerInfo;
        return $this;
    }
    /**
     * Get Recurring value
     * @return \StructType\RecurringType|null
     */
    public function getRecurring()
    {
        return $this->Recurring;
    }
    /**
     * Set Recurring value
     * @param \StructType\RecurringType $recurring
     * @return \StructType\TokenPaymentRequestType
     */
    public function setRecurring(\StructType\RecurringType $recurring = null)
    {
        $this->Recurring = $recurring;
        return $this;
    }
    /**
     * Get TokenizationInfo value
     * @return \StructType\TokenizationInfoType|null
     */
    public function getTokenizationInfo()
    {
        return $this->TokenizationInfo;
    }
    /**
     * Set TokenizationInfo value
     * @param \StructType\TokenizationInfoType $tokenizationInfo
     * @return \StructType\TokenPaymentRequestType
     */
    public function setTokenizationInfo(\StructType\TokenizationInfoType $tokenizationInfo = null)
    {
        $this->TokenizationInfo = $tokenizationInfo;
        return $this;
    }
    /**
     * Get CVV value
     * @return string|null
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \StructType\TokenPaymentRequestType
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV, true), gettype($cVV)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($cVV) && mb_strlen($cVV) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($cVV)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($cVV) && mb_strlen($cVV) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($cVV)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($cVV) && !preg_match('/[0-9]+/', $cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($cVV, true)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get BudgetPeriod value
     * @return string|null
     */
    public function getBudgetPeriod()
    {
        return $this->BudgetPeriod;
    }
    /**
     * Set BudgetPeriod value
     * @param string $budgetPeriod
     * @return \StructType\TokenPaymentRequestType
     */
    public function setBudgetPeriod($budgetPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($budgetPeriod) && !is_string($budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budgetPeriod, true), gettype($budgetPeriod)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($budgetPeriod) && mb_strlen($budgetPeriod) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($budgetPeriod)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($budgetPeriod) && mb_strlen($budgetPeriod) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($budgetPeriod)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($budgetPeriod) && !preg_match('/[0-9]+/', $budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($budgetPeriod, true)), __LINE__);
        }
        $this->BudgetPeriod = $budgetPeriod;
        return $this;
    }
}
