<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLegType StructType
 * @subpackage Structs
 */
class FlightLegType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $DepartureAirport;
    /**
     * The DepartureCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureCountry;
    /**
     * The DepartureCity
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $DepartureCity;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $ArrivalAirport;
    /**
     * The ArrivalCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalCountry;
    /**
     * The ArrivalCity
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $ArrivalCity;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z0-9]{2}
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The MarketingCarrierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MarketingCarrierName;
    /**
     * The IssuingCarrierCode
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z0-9]{2}
     * @var string
     */
    public $IssuingCarrierCode;
    /**
     * The IssuingCarrierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssuingCarrierName;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FlightNumber;
    /**
     * The BaseFareAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BaseFareAmount;
    /**
     * The BaseFareCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaseFareCurrency;
    /**
     * The DepartureAirportTimeZone
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [+-][0-9]{2}:[0-9]{2}
     * @var string
     */
    public $DepartureAirportTimeZone;
    /**
     * The ArrivalAirportTimeZone
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [+-][0-9]{2}:[0-9]{2}
     * @var string
     */
    public $ArrivalAirportTimeZone;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareClass;
    /**
     * Constructor method for FlightLegType
     * @uses FlightLegType::setDepartureAirport()
     * @uses FlightLegType::setDepartureCountry()
     * @uses FlightLegType::setDepartureCity()
     * @uses FlightLegType::setDepartureDateTime()
     * @uses FlightLegType::setArrivalAirport()
     * @uses FlightLegType::setArrivalCountry()
     * @uses FlightLegType::setArrivalCity()
     * @uses FlightLegType::setArrivalDateTime()
     * @uses FlightLegType::setMarketingCarrierCode()
     * @uses FlightLegType::setMarketingCarrierName()
     * @uses FlightLegType::setIssuingCarrierCode()
     * @uses FlightLegType::setIssuingCarrierName()
     * @uses FlightLegType::setFlightNumber()
     * @uses FlightLegType::setBaseFareAmount()
     * @uses FlightLegType::setBaseFareCurrency()
     * @uses FlightLegType::setDepartureAirportTimeZone()
     * @uses FlightLegType::setArrivalAirportTimeZone()
     * @uses FlightLegType::setFareBasisCode()
     * @uses FlightLegType::setFareClass()
     * @param string $departureAirport
     * @param string $departureCountry
     * @param string $departureCity
     * @param string $departureDateTime
     * @param string $arrivalAirport
     * @param string $arrivalCountry
     * @param string $arrivalCity
     * @param string $arrivalDateTime
     * @param string $marketingCarrierCode
     * @param string $marketingCarrierName
     * @param string $issuingCarrierCode
     * @param string $issuingCarrierName
     * @param string $flightNumber
     * @param int $baseFareAmount
     * @param string $baseFareCurrency
     * @param string $departureAirportTimeZone
     * @param string $arrivalAirportTimeZone
     * @param string $fareBasisCode
     * @param string $fareClass
     */
    public function __construct($departureAirport = null, $departureCountry = null, $departureCity = null, $departureDateTime = null, $arrivalAirport = null, $arrivalCountry = null, $arrivalCity = null, $arrivalDateTime = null, $marketingCarrierCode = null, $marketingCarrierName = null, $issuingCarrierCode = null, $issuingCarrierName = null, $flightNumber = null, $baseFareAmount = null, $baseFareCurrency = null, $departureAirportTimeZone = null, $arrivalAirportTimeZone = null, $fareBasisCode = null, $fareClass = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setDepartureCountry($departureCountry)
            ->setDepartureCity($departureCity)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalAirport($arrivalAirport)
            ->setArrivalCountry($arrivalCountry)
            ->setArrivalCity($arrivalCity)
            ->setArrivalDateTime($arrivalDateTime)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setMarketingCarrierName($marketingCarrierName)
            ->setIssuingCarrierCode($issuingCarrierCode)
            ->setIssuingCarrierName($issuingCarrierName)
            ->setFlightNumber($flightNumber)
            ->setBaseFareAmount($baseFareAmount)
            ->setBaseFareCurrency($baseFareCurrency)
            ->setDepartureAirportTimeZone($departureAirportTimeZone)
            ->setArrivalAirportTimeZone($arrivalAirportTimeZone)
            ->setFareBasisCode($fareBasisCode)
            ->setFareClass($fareClass);
    }
    /**
     * Get DepartureAirport value
     * @return string
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param string $departureAirport
     * @return \StructType\FlightLegType
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirport, true), gettype($departureAirport)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($departureAirport) && !preg_match('/[A-Z]{3}/', $departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($departureAirport, true)), __LINE__);
        }
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get DepartureCountry value
     * @return string
     */
    public function getDepartureCountry()
    {
        return $this->DepartureCountry;
    }
    /**
     * Set DepartureCountry value
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureCountry
     * @return \StructType\FlightLegType
     */
    public function setDepartureCountry($departureCountry = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($departureCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryType', is_array($departureCountry) ? implode(', ', $departureCountry) : var_export($departureCountry, true), implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->DepartureCountry = $departureCountry;
        return $this;
    }
    /**
     * Get DepartureCity value
     * @return string
     */
    public function getDepartureCity()
    {
        return $this->DepartureCity;
    }
    /**
     * Set DepartureCity value
     * @param string $departureCity
     * @return \StructType\FlightLegType
     */
    public function setDepartureCity($departureCity = null)
    {
        // validation for constraint: string
        if (!is_null($departureCity) && !is_string($departureCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureCity, true), gettype($departureCity)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($departureCity) && !preg_match('/[A-Z]{3}/', $departureCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($departureCity, true)), __LINE__);
        }
        $this->DepartureCity = $departureCity;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\FlightLegType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return string
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param string $arrivalAirport
     * @return \StructType\FlightLegType
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirport) && !is_string($arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirport, true), gettype($arrivalAirport)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($arrivalAirport) && !preg_match('/[A-Z]{3}/', $arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($arrivalAirport, true)), __LINE__);
        }
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get ArrivalCountry value
     * @return string
     */
    public function getArrivalCountry()
    {
        return $this->ArrivalCountry;
    }
    /**
     * Set ArrivalCountry value
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalCountry
     * @return \StructType\FlightLegType
     */
    public function setArrivalCountry($arrivalCountry = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($arrivalCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryType', is_array($arrivalCountry) ? implode(', ', $arrivalCountry) : var_export($arrivalCountry, true), implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->ArrivalCountry = $arrivalCountry;
        return $this;
    }
    /**
     * Get ArrivalCity value
     * @return string
     */
    public function getArrivalCity()
    {
        return $this->ArrivalCity;
    }
    /**
     * Set ArrivalCity value
     * @param string $arrivalCity
     * @return \StructType\FlightLegType
     */
    public function setArrivalCity($arrivalCity = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalCity) && !is_string($arrivalCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalCity, true), gettype($arrivalCity)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{3})
        if (!is_null($arrivalCity) && !preg_match('/[A-Z]{3}/', $arrivalCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{3}', var_export($arrivalCity, true)), __LINE__);
        }
        $this->ArrivalCity = $arrivalCity;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\FlightLegType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * @return string
     */
    public function getMarketingCarrierCode()
    {
        return $this->MarketingCarrierCode;
    }
    /**
     * Set MarketingCarrierCode value
     * @param string $marketingCarrierCode
     * @return \StructType\FlightLegType
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9]{2})
        if (!is_null($marketingCarrierCode) && !preg_match('/[A-Z0-9]{2}/', $marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9]{2}', var_export($marketingCarrierCode, true)), __LINE__);
        }
        $this->MarketingCarrierCode = $marketingCarrierCode;
        return $this;
    }
    /**
     * Get MarketingCarrierName value
     * @return string
     */
    public function getMarketingCarrierName()
    {
        return $this->MarketingCarrierName;
    }
    /**
     * Set MarketingCarrierName value
     * @param string $marketingCarrierName
     * @return \StructType\FlightLegType
     */
    public function setMarketingCarrierName($marketingCarrierName = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierName) && !is_string($marketingCarrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierName, true), gettype($marketingCarrierName)), __LINE__);
        }
        $this->MarketingCarrierName = $marketingCarrierName;
        return $this;
    }
    /**
     * Get IssuingCarrierCode value
     * @return string
     */
    public function getIssuingCarrierCode()
    {
        return $this->IssuingCarrierCode;
    }
    /**
     * Set IssuingCarrierCode value
     * @param string $issuingCarrierCode
     * @return \StructType\FlightLegType
     */
    public function setIssuingCarrierCode($issuingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuingCarrierCode) && !is_string($issuingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuingCarrierCode, true), gettype($issuingCarrierCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9]{2})
        if (!is_null($issuingCarrierCode) && !preg_match('/[A-Z0-9]{2}/', $issuingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9]{2}', var_export($issuingCarrierCode, true)), __LINE__);
        }
        $this->IssuingCarrierCode = $issuingCarrierCode;
        return $this;
    }
    /**
     * Get IssuingCarrierName value
     * @return string
     */
    public function getIssuingCarrierName()
    {
        return $this->IssuingCarrierName;
    }
    /**
     * Set IssuingCarrierName value
     * @param string $issuingCarrierName
     * @return \StructType\FlightLegType
     */
    public function setIssuingCarrierName($issuingCarrierName = null)
    {
        // validation for constraint: string
        if (!is_null($issuingCarrierName) && !is_string($issuingCarrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuingCarrierName, true), gettype($issuingCarrierName)), __LINE__);
        }
        $this->IssuingCarrierName = $issuingCarrierName;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\FlightLegType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get BaseFareAmount value
     * @return int
     */
    public function getBaseFareAmount()
    {
        return $this->BaseFareAmount;
    }
    /**
     * Set BaseFareAmount value
     * @param int $baseFareAmount
     * @return \StructType\FlightLegType
     */
    public function setBaseFareAmount($baseFareAmount = null)
    {
        // validation for constraint: int
        if (!is_null($baseFareAmount) && !(is_int($baseFareAmount) || ctype_digit($baseFareAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baseFareAmount, true), gettype($baseFareAmount)), __LINE__);
        }
        $this->BaseFareAmount = $baseFareAmount;
        return $this;
    }
    /**
     * Get BaseFareCurrency value
     * @return string
     */
    public function getBaseFareCurrency()
    {
        return $this->BaseFareCurrency;
    }
    /**
     * Set BaseFareCurrency value
     * @uses \EnumType\CurrencyType::valueIsValid()
     * @uses \EnumType\CurrencyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseFareCurrency
     * @return \StructType\FlightLegType
     */
    public function setBaseFareCurrency($baseFareCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyType::valueIsValid($baseFareCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyType', is_array($baseFareCurrency) ? implode(', ', $baseFareCurrency) : var_export($baseFareCurrency, true), implode(', ', \EnumType\CurrencyType::getValidValues())), __LINE__);
        }
        $this->BaseFareCurrency = $baseFareCurrency;
        return $this;
    }
    /**
     * Get DepartureAirportTimeZone value
     * @return string|null
     */
    public function getDepartureAirportTimeZone()
    {
        return $this->DepartureAirportTimeZone;
    }
    /**
     * Set DepartureAirportTimeZone value
     * @param string $departureAirportTimeZone
     * @return \StructType\FlightLegType
     */
    public function setDepartureAirportTimeZone($departureAirportTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportTimeZone) && !is_string($departureAirportTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportTimeZone, true), gettype($departureAirportTimeZone)), __LINE__);
        }
        // validation for constraint: pattern([+-][0-9]{2}:[0-9]{2})
        if (!is_null($departureAirportTimeZone) && !preg_match('/[+-][0-9]{2}:[0-9]{2}/', $departureAirportTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [+-][0-9]{2}:[0-9]{2}', var_export($departureAirportTimeZone, true)), __LINE__);
        }
        $this->DepartureAirportTimeZone = $departureAirportTimeZone;
        return $this;
    }
    /**
     * Get ArrivalAirportTimeZone value
     * @return string|null
     */
    public function getArrivalAirportTimeZone()
    {
        return $this->ArrivalAirportTimeZone;
    }
    /**
     * Set ArrivalAirportTimeZone value
     * @param string $arrivalAirportTimeZone
     * @return \StructType\FlightLegType
     */
    public function setArrivalAirportTimeZone($arrivalAirportTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportTimeZone) && !is_string($arrivalAirportTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportTimeZone, true), gettype($arrivalAirportTimeZone)), __LINE__);
        }
        // validation for constraint: pattern([+-][0-9]{2}:[0-9]{2})
        if (!is_null($arrivalAirportTimeZone) && !preg_match('/[+-][0-9]{2}:[0-9]{2}/', $arrivalAirportTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [+-][0-9]{2}:[0-9]{2}', var_export($arrivalAirportTimeZone, true)), __LINE__);
        }
        $this->ArrivalAirportTimeZone = $arrivalAirportTimeZone;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FlightLegType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FareClass value
     * @return string|null
     */
    public function getFareClass()
    {
        return $this->FareClass;
    }
    /**
     * Set FareClass value
     * @param string $fareClass
     * @return \StructType\FlightLegType
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        $this->FareClass = $fareClass;
        return $this;
    }
}
