<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ThreeDSecureDetailsType StructType
 * @subpackage Structs
 */
class ThreeDSecureDetailsType extends AbstractStructBase
{
    /**
     * The Enrolled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Enrolled;
    /**
     * The ParesStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParesStatus;
    /**
     * The Eci
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Eci;
    /**
     * Constructor method for ThreeDSecureDetailsType
     * @uses ThreeDSecureDetailsType::setEnrolled()
     * @uses ThreeDSecureDetailsType::setParesStatus()
     * @uses ThreeDSecureDetailsType::setEci()
     * @param string $enrolled
     * @param string $paresStatus
     * @param string $eci
     */
    public function __construct($enrolled = null, $paresStatus = null, $eci = null)
    {
        $this
            ->setEnrolled($enrolled)
            ->setParesStatus($paresStatus)
            ->setEci($eci);
    }
    /**
     * Get Enrolled value
     * @return string|null
     */
    public function getEnrolled()
    {
        return $this->Enrolled;
    }
    /**
     * Set Enrolled value
     * @uses \EnumType\EnrolledStatusType::valueIsValid()
     * @uses \EnumType\EnrolledStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enrolled
     * @return \StructType\ThreeDSecureDetailsType
     */
    public function setEnrolled($enrolled = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnrolledStatusType::valueIsValid($enrolled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnrolledStatusType', is_array($enrolled) ? implode(', ', $enrolled) : var_export($enrolled, true), implode(', ', \EnumType\EnrolledStatusType::getValidValues())), __LINE__);
        }
        $this->Enrolled = $enrolled;
        return $this;
    }
    /**
     * Get ParesStatus value
     * @return string|null
     */
    public function getParesStatus()
    {
        return $this->ParesStatus;
    }
    /**
     * Set ParesStatus value
     * @uses \EnumType\PaResStatusType::valueIsValid()
     * @uses \EnumType\PaResStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paresStatus
     * @return \StructType\ThreeDSecureDetailsType
     */
    public function setParesStatus($paresStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaResStatusType::valueIsValid($paresStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaResStatusType', is_array($paresStatus) ? implode(', ', $paresStatus) : var_export($paresStatus, true), implode(', ', \EnumType\PaResStatusType::getValidValues())), __LINE__);
        }
        $this->ParesStatus = $paresStatus;
        return $this;
    }
    /**
     * Get Eci value
     * @return string|null
     */
    public function getEci()
    {
        return $this->Eci;
    }
    /**
     * Set Eci value
     * @param string $eci
     * @return \StructType\ThreeDSecureDetailsType
     */
    public function setEci($eci = null)
    {
        // validation for constraint: string
        if (!is_null($eci) && !is_string($eci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eci, true), gettype($eci)), __LINE__);
        }
        $this->Eci = $eci;
        return $this;
    }
}
